//
//  YHPrinciplePhotoCollectCell.swift
//  galaxy
//
//  Created by edy on 2024/8/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPrinciplePhotoCollectCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHPrinciplePhotoCollectCell"

    var clickBlock: (() -> Void)?
    lazy var imgView: UIImageView = {
        let imgView = UIImageView()
        imgView.layer.cornerRadius = 3.0
        imgView.clipsToBounds = true
        imgView.image = UIImage(named: "global_default_image")
        return imgView
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 12)
        label.textColor = UIColor(hex: 0x94A3B8)
        label.textAlignment = .center
        label.text = "XXXXXX"
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func updateModel(_ model: YHResultImageList) {
        titleLabel.text = model.applicationName
        imgView.sd_setImage(with: URL(string: model.image), placeholderImage: UIImage(named: "global_default_image"))
        
    }
    
    var isSinglePhoto: Bool = false {
        didSet {
            let imgHeight = isSinglePhoto ? 170.0 : 80.0
            let gap = isSinglePhoto ? 16.0 : 12.0
            imgView.snp.updateConstraints { make in
                make.height.equalTo(imgHeight)
            }
            
            titleLabel.snp.updateConstraints { make in
                make.top.equalTo(imgView.snp.bottom).offset(gap)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    func createUI() {
        
        self.contentView.backgroundColor = .clear
        self.backgroundColor = .clear
        self.addSubview(imgView)
        self.addSubview(titleLabel)
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(didPhotoClicked))
        self.contentView.addGestureRecognizer(tap)
        
        imgView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(80.0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(imgView.snp.bottom).offset(12.0)
            make.left.right.equalToSuperview()
            make.height.equalTo(18.0)
        }
    }
    
    @objc func didPhotoClicked() {
        clickBlock?()
    }
}
