//
//  YHHKVisaRenewalApplicationHeader.swift
//  galaxy
//
//  Created by alexzzw on 2025/3/6.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKVisaRenewalApplicationHeader: UIView {
    private static let ratio = 420.0 / 686.0
    private static let margin: CGFloat = 16

    static var viewHeight: CGFloat {
        return (KScreenWidth - margin * 2) * ratio + margin
    }

    private lazy var infoTipsImageView: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "visa_renewal_pay_tips"))
        imageView.contentMode = .scaleAspectFit
        return imageView
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        addSubview(infoTipsImageView)
        infoTipsImageView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(YHHKVisaRenewalApplicationHeader.margin)
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(YHHKVisaRenewalApplicationHeader.margin)
            make.right.equalToSuperview().offset(-YHHKVisaRenewalApplicationHeader.margin)
        }
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
