//
//  YHDetailViewController.swift
//  galaxy
//
//  Created by EDY on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHDetailViewController: YHBaseViewController {
    
    var tableView: UITableView!
    var viewModel: YHListViewModel = YHListViewModel()
    var model = YHHKEventModel()
    
    lazy var headView: YHHeadView = {
        let headView = YHHeadView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 581))
        return headView
    }()
    
    lazy var navBar: YHCustomNavigationBar = {
        let bar = YHCustomNavigationBar.navBar()
        bar.backgroundColor = .clear
        bar.backButton.setImage(UIImage(named: "back_icon_white"), for: .normal)
        bar.backBlock = {
            [weak self] in
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
        return bar
    }()
    
    lazy var navView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        view.addSubview(self.navBar)
        self.navBar.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(k_Height_NavContentBar)
        }
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        loadData()
    }
}

extension YHDetailViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return (self.viewModel.model.first?.list.count ?? 1) - 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHListTableViewCell.self)
        cell.imageUrl = self.viewModel.model.first?.list[indexPath.row + 1]
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 243.fix
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }

    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
}

extension YHDetailViewController {
    func setView() {
        gk_navigationBar.isHidden = true
        view.backgroundColor = .white
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.showsHorizontalScrollIndicator = false
            tableView.showsVerticalScrollIndicator = false
            tableView.dataSource = self
            tableView.delegate = self
            tableView.tableHeaderView = headView
            tableView.tableFooterView = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 20))
            tableView.register(cellWithClass: YHListTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
        view.addSubview(self.navView)
        self.navView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(k_Height_NavigationtBarAndStatuBar)
        }
    }
    
    func loadData() {
        viewModel.getToolsEvent(pid: model.id) {[weak self] _, _ in
            guard let self = self else { return }
            guard let url = URL(string: self.viewModel.model.first?.list.first) else { return }
            self.headView.imageView.kf.setImage(with: url)
            self.tableView.reloadData()
        }
    }
}

extension YHDetailViewController: UIScrollViewDelegate {
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        
        var percent = scrollView.contentOffset.y/k_Height_NavigationtBarAndStatuBar
        if percent < 0.0 {
            percent = 0.0
        } else if percent > 1.0 {
            percent = 1.0
        }
        navView.backgroundColor = UIColor(hex: 0xFFFFFF, alpha: percent)
        
        if percent >= 0.5 {
            navBar.backButton.setImage(UIImage(named: "back_icon"), for: .normal)
            navBar.title = self.model.tag
            
        } else {
            navBar.backButton.setImage(UIImage(named: "back_icon_white"), for: .normal)
            navBar.title = ""
        }
    }
}
