//
//  YHVisaRenewalResidenceActionCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalResidenceActionCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHVisaRenewalResidenceActionCell"
    
    var rightButtonEvent: (() -> Void)?
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 15)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var rightButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitleColor(.mainTextColor, for: .normal)
        button.titleLabel?.font = .PFSC_M(ofSize: 12)
        button.addTarget(self, action: #selector(rightButtonClicked), for: .touchUpInside)
        button.layer.cornerRadius = 2
        button.clipsToBounds = true
        return button
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, presenceStatus: YHVisaRenewalPresenceStatus, cellType: YHResignRoundCellType = .mid) {
        updateCellCorner(cellType)
        infoTitleLabel.text = title
        rightButton.setTitle(presenceStatus.title, for: .normal)
        rightButton.setTitleColor(presenceStatus.titleColor, for: .normal)
        rightButton.backgroundColor = presenceStatus.bgColor
        let isBottom = cellType == .bottom
        bottomLineView.isHidden = isBottom ? true : false
        let bottomMargin: CGFloat = isBottom ? 28 : 16
        infoTitleLabel.snp.remakeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-bottomMargin).priority(.high)
        }
    }
}

extension YHVisaRenewalResidenceActionCell {
    @objc private func rightButtonClicked() {
        rightButtonEvent?()
    }
    
    private func setupUI() {
        subContainerView.radius = 6
        updateCellCorner(.mid)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(rightButton)
        subContainerView.addSubview(bottomLineView)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightButton.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16).priority(.high)
        }
        
        rightButton.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(6)
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(26)
            make.width.equalTo(72)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel.snp.left)
            make.right.equalTo(rightButton.snp.right)
            make.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
    }
}
