//
//  YHManagerFuncGuildeCheckView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/9/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHManagerFuncGuildeCheckView: UIView {
    
    typealias Block = () -> Void
    var block: Block?
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0x0F1214, alpha: 0.6)
        return view
    }()
    
    lazy var closeBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.addTarget(self, action: #selector(clickCloseBtn), for: .touchUpInside)
        button.setTitle("知道啦", for: .normal)
        button.setTitleColor(UIColor(hexString: "#232D71"), for: .normal)
        button.backgroundColor = .white
        button.layer.cornerRadius = 2
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 12)
        
        return button
    }()
    
    lazy var imageV1: UIImageView = {
        let imageV  = UIImageView()
        imageV.image = UIImage(named: "home_guild_yhmanager_1")
        imageV.contentMode = .scaleToFill
        imageV.clipsToBounds = true
        imageV.isUserInteractionEnabled = true
        return imageV
    }()
    
    lazy var imageV2: UIImageView = {
        let imageV  = UIImageView()
        imageV.image = UIImage(named: "home_guild_yhmanager_2")
        imageV.contentMode = .scaleToFill
        imageV.clipsToBounds = true
        return imageV
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        let tap: UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(clickCloseBtn))
        addGestureRecognizer(tap)
    }
    
    var itemRect: CGRect = CGRect.zero {
        didSet {
            updateUI()
        }
    }
    
}

extension YHManagerFuncGuildeCheckView {
    
    static func sheetView() -> YHManagerFuncGuildeCheckView {
        let view = YHManagerFuncGuildeCheckView(frame: UIScreen.main.bounds)
        return view
    }
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func clickCloseBtn() {
        self.block?()
        dismiss()
    }
}

private extension YHManagerFuncGuildeCheckView {
    func updateUI() {
        
        imageV2.snp.removeConstraints()
        let offsetY = KScreenHeight - itemRect.origin.y - 63.fix
        imageV2.snp.remakeConstraints { make in
            make.bottom.equalToSuperview().offset(-offsetY)
            make.left.equalTo(30)
            make.right.equalTo(-30)
            make.height.equalTo(63.fix)
        }
        
    }
    
    func setupUI() {
        addSubview(blackMaskView)
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        blackMaskView.addSubview(imageV2)
        imageV2.snp.makeConstraints { make in
            make.bottom.equalToSuperview().offset(-142.0)
            make.left.equalTo(30)
            make.right.equalTo(-30)
            make.height.equalTo(63.fix)
        }
        
        blackMaskView.addSubview(imageV1)
        imageV1.snp.makeConstraints { make in
            make.bottom.equalTo(imageV2.snp.top).offset(-24)
            make.left.equalTo(30)
            make.right.equalTo(-30)
            make.height.equalTo(228.fix)
        }
        imageV1.addSubview(closeBtn)
        closeBtn.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(-22)
            make.width.equalTo(66)
            make.height.equalTo(30)
        }
        
        closeBtn.YH_clickEdgeInsets = UIEdgeInsets(top: 10, left: 10, bottom: 10, right: 10)
    }
}
