//
//  YHListViewController.swift
//  galaxy
//
//  Created by EDY on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHListViewController: YHBaseViewController {
    
    var tableView: UITableView!
    var viewModel: YHListViewModel = YHListViewModel()
        
    lazy var visitBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("预约到访", for: .normal)
        btn.addTarget(self, action: #selector(visitBtnClicked), for: .touchUpInside)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandGrayColor8
        btn.layer.cornerRadius = 3.0
        btn.masksToBounds = true
        return btn
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        loadData()
    }
    
    @objc func visitBtnClicked() {
        
    }
}

extension YHListViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.viewModel.model.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHListTableViewCell.self)
        cell.dataSource = self.viewModel.model[indexPath.row]
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 204.fix
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 6
    }

    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }

    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let vc = YHDetailViewController()
        vc.model = self.viewModel.model[indexPath.row]
        self.navigationController?.pushViewController(vc)
    }
}

extension YHListViewController {
    
    func setView() {
        gk_navTitle = "关于银河湾"
        view.backgroundColor = .white
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.showsHorizontalScrollIndicator = false
            tableView.showsVerticalScrollIndicator = false
            tableView.dataSource = self
            tableView.delegate = self
            tableView.register(cellWithClass: YHListTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        view.addSubview(visitBtn)

        tableView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(visitBtn.snp.top).offset(-8)
        }
        visitBtn.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(46)
            make.bottom.equalTo(-10-k_Height_safeAreaInsetsBottom())
        }
        
    }
    
    func loadData() {
        viewModel.getToolsEvent(pid: 7) {[weak self] _, _ in
            guard let self = self else { return }
            self.tableView.reloadData()
        }
    }
}

class YHListTableViewCell: UITableViewCell {
    var centerImageView: UIImageView!

    var dataSource: YHHKEventModel? {
        didSet {
            guard let url = URL(string: dataSource?.list.first) else { return }
            centerImageView.kf.setImage(with: url)
        }
    }
    
    var imageUrl: String? {
        didSet {
            guard let url = URL(string: imageUrl) else { return }
            centerImageView.kf.setImage(with: url)
        }
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        self.backgroundColor = .white
        centerImageView = {
            let imageView = UIImageView()
            imageView.isUserInteractionEnabled = true
            imageView.image = UIImage(named: "invitation_with_gifts_first")
            imageView.contentMode = .scaleAspectFill
            return imageView
        }()
        contentView.addSubview(centerImageView)
        centerImageView.snp.makeConstraints { make in
            make.top.equalTo(10)
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.bottom.equalTo(-10)
        }
    }
}
