//
//  YHFixProductItemView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//
import UIKit
import AttributedString

class YHFixProductItemView: UIView {
    
    var productModel = YHAIListItemModel() {
        didSet {
            iconImgView.sd_setImage(with: URL(string: productModel.cover), placeholderImage: UIImage(named: ""))
            titleLabel.text = productModel.title
            subtitleLabel.text = productModel.description
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var bottomLineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    lazy var iconImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: ""))
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "高才A香港企明星(7)"
        return lable
    }()
    
    lazy var subtitleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "高才A香港企明星(7)"
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didClickProductItem() {
        if !productModel.redirectPath.isEmpty {
            let vc = YHH5WebViewVC()
            vc.isFullScreenFlag = false
            vc.url = productModel.redirectPath
            UIViewController.current?.navigationController?.pushViewController(vc)
        }
    }
    
    func createUI() {
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(didClickProductItem))
        self.addGestureRecognizer(tap)
        
        self.addSubview(iconImgView)
        self.addSubview(titleLabel)
        self.addSubview(subtitleLabel)
        self.addSubview(bottomLineView)
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(70)
            make.left.equalTo(16)
            make.top.equalTo(20)
            make.bottom.equalTo(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgView.snp.right).offset(12)
            make.right.equalTo(-16)
            make.top.equalTo(iconImgView)
            make.height.equalTo(42)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel)
            make.right.equalTo(-16)
            make.bottom.equalTo(iconImgView)
            make.height.equalTo(17)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.left.equalTo(iconImgView)
            make.right.equalTo(-16)
            make.height.equalTo(0.5)
            make.bottom.equalTo(0)
        }
    }
}
