//
//  YHCircleEntryView.swift
//  galaxy
//
//  Created by alexzzw on 2025/10/11.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCircleEntryView: UIView {

    static let viewH = 88.0
    var circleEntryBlock: (() -> Void)?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        
        let tap: UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var bkgImageV: UIImageView = {
        let imgV: UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "circle_entry_bkg")
        imgV.clipsToBounds = true
        return imgV
    }()
    
    lazy var lable1: UILabel = {
        let lable: UILabel = UILabel()
        lable.text = "创业社区"
        lable.font = UIFont.PFSC_B(ofSize: 17)
        lable.textColor = UIColor.mainTextColor
        return lable
    }()
    
    lazy var lable2: UILabel = {
        let lable: UILabel = UILabel()
        lable.text = "为您找到更多同行"
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.textColor = UIColor.brandGrayColor6
        return lable
    }()
    
    lazy var iconImageV: UIImageView = {
        let imgV: UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "circle_entry_left_icon")
        imgV.clipsToBounds = true
        return imgV
    }()
    
    lazy var rightButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitle("前往查看", for: .normal)
        button.setTitleColor(.white, for: .normal)
        button.backgroundColor = .brandGrayColor8
        button.titleLabel?.font = .PFSC_M(ofSize: 12)
        button.addTarget(self, action: #selector(rightButtonClick), for: .touchUpInside)
        return button
    }()
    
    lazy var centerView: UIView = {
        let view = UIView()
        return view
    }()
}

extension YHCircleEntryView {
    
    @objc func tapButton(gestureRecognizer: UITapGestureRecognizer) {
        // 跳转Circle
        circleEntryBlock?()
    }
    
    @objc func rightButtonClick() {
        // 跳转Circle
        circleEntryBlock?()
    }
    
    func setupUI() {
        addSubview(bkgImageV)
        addSubview(iconImageV)
        addSubview(centerView)
        centerView.addSubview(lable1)
        centerView.addSubview(lable2)
        addSubview(rightButton)
        
        bkgImageV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        iconImageV.snp.makeConstraints { make in
            make.width.height.equalTo(76)
            make.left.equalTo(8)
            make.centerY.equalToSuperview()
        }
        
        centerView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(iconImageV.snp.right).offset(8)
            make.right.lessThanOrEqualTo(rightButton.snp.left).offset(-8)
        }
        
        lable1.snp.makeConstraints { make in
            make.left.top.right.equalToSuperview()
        }
        
        lable2.snp.makeConstraints { make in
            make.top.equalTo(lable1.snp.bottom).offset(3)
            make.left.bottom.right.equalToSuperview()
        }
        
        rightButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-24)
            make.height.equalTo(32)
            make.width.equalTo(80)
        }
    }
}
