//
//  YHEducationInfo.swift
//  galaxy
//
//  Created by edy on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHEducationListInfo: SmartCodable {
    var orderId: Int = 0
    var eduList: [YHEducationInfo]?
    var quaList: [YHQualificationInfo]?
    var isNameSame: Bool?
    var isSpouseNameSame: Bool?
    // 1=已婚,2=未婚,3=离婚,4=分居,5=丧偶,6=事实婚姻,7=鳏寡
    var married: Int = 0
    var isNameSameNew: Int = 0
    
    func isMarried() -> Bool {
        return married != 2
    }

    enum CodingKeys: String, CodingKey {
        case orderId = "order_id"
        case eduList = "edu_list"
        case quaList = "qua_list"
        case isNameSame = "is_name_same"
        case isNameSameNew = "is_name_same_new"
        
        case isSpouseNameSame = "is_spouse_name_same"
        case married = "married"
    }

    required init() {
        
    }
}

class YHEducationInfo: SmartCodable {
    var id: Int = 0
    var college: String?
    var major: String?
    var degree: String?
    var admissionTime: String?
    var graduateTime: String?
    var vacantNum: Int = 0
    var majorOther: String?
    var hasBachelorDegree: Int = 0
    var college_id: Int = 0
    enum CodingKeys: String, CodingKey {
        case id = "id"
        case college = "college"
        case major = "major"
        case degree = "degree"
        case admissionTime = "admission_time"
        case graduateTime = "graduate_time"
        case vacantNum = "vacant_num"
        case majorOther = "major_other"
        case hasBachelorDegree = "has_bachelor_degree"
    }
    
    required init() {
        
    }
    
    func getDegree() -> String {
        if hasBachelorDegree == 1 {
            return "学士学位"
        }
        if hasBachelorDegree == 2 {
            return "无学位"
        }
        return ""
    }
    
    func getRealMajor() -> String? {
        if let major = major, major == "其他" {
            return majorOther
        }
        return major
    }
}

class YHQualificationInfo: SmartCodable {
    var id: Int = 0
    var qualification: String?
    var vacantNum: Int = 0

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case qualification = "qualification"
        case vacantNum = "vacant_num"
    }

    required init() {
        
    }
}

class YHEducationDetailInfo: SmartCodable {
    
    var id: Int = 0
    var college: String = ""
    var teachingFormat: String = ""
    var admissionTime: String = ""
    var graduateTime: String = ""
    var degree: String = ""
    var major: String = ""
    var tempMajor: String = "" // 保存专业中文名称
    var degreeType: String = ""
    var schoolAddress: YHCollegeAddress = YHCollegeAddress()
    var isAboardSchool: Bool = false
    var majorOther: String = ""
    var hasBachelorDegree: Int = 0
    var college_id: Int = 0
    // 证件提供确认 0 未选择 1 是  2 否
    var certConfirm: Int = 0
    
    func isNeedInputMajor() -> Bool {
        return major == "其他"
    }
    
    func getDegree() -> String {
        if hasBachelorDegree == 1 {
            return "学士学位"
        }
        if hasBachelorDegree == 2 {
            return "无学位"
        }
        return ""
    }
    
    enum CodingKeys: String, CodingKey {
        
        case id = "id"
        case college = "college"
        case teachingFormat = "teaching_format"
        case admissionTime = "admission_time"
        case graduateTime = "graduate_time"
        case degree = "degree"
        case major = "major"
        case tempMajor = "temp_major"
        case degreeType = "degree_type"
        case schoolAddress = "school_address"
        case isAboardSchool = "is_aboard_school"
        case majorOther = "major_other"
        case hasBachelorDegree = "has_bachelor_degree"
        case certConfirm = "cert_confirm"
        case college_id = "college_id"
    }
    
    required init() {
        
    }
    // 学校是否在国外 默认是在国内
    func isSchoolInAboard() -> Bool {
        if schoolAddress.country.isEmpty { return false }
        if schoolAddress.country.contains("中国") {
            return false
        }
        return true
    }
}

class YHCollegeAddress: Codable {
   
    var area: [String] = []
    var country: String = ""
    var details: String = ""
    var foreign: String = ""

    enum CodingKeys: String, CodingKey {
        case area = "area"
        case country = "country"
        case details = "details"
        case foreign = "foreign"
    }

    required init() {
    
    }
}

class YHQualificationDetailInfo: SmartCodable {
        var id: Int = 0
        var certName: String = ""
        var issuingAgent: String = ""
        var issuingYear: Int = 0
        var issuingAddr: YHCollegeAddress = YHCollegeAddress()
        var isAboardAddr: Bool = false

        enum CodingKeys: String, CodingKey {
            case id = "id"
            case certName = "cert_name"
            case issuingAgent = "issuing_agent"
            case issuingYear = "issuing_year"
            case issuingAddr = "issuing_addr"
            case isAboardAddr = "is_aboard_addr"
        }
    
    // 学校是否在国外 默认是在国内
    func isCollegeInAboard() -> Bool {
        if issuingAddr.country.isEmpty { return false }
        if issuingAddr.country.contains("中国") {
            return false
        }
        return true
    }

    required init() {
        
    }
}

class YHCollegeInfo: SmartCodable {
    
    var id: Int = 0
    var zhName: String = ""
    var enName: String = ""
    // 0-未知，1-中文主校，2-英文主校
    var mainNameType: Int = 0
    var schoolType: Int = 0
    var assoProduct: [Int] = []
    var color: String = ""

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case zhName = "zh_name"
        case enName = "en_name"
        case mainNameType = "main_name_type"
        case schoolType = "school_type"
        case assoProduct = "asso_product"
        case color = "color"
    }
    
    func getCollegeName() -> String {
        if mainNameType == 1 {
            return zhName
            
        } else if mainNameType == 2 {
            return enName
        }
        if !zhName.isEmpty {
            return zhName
        }
        return enName
    }
    
    func getFullCollegeName() -> String {
        var result = ""
        if !zhName.isEmpty {
            result += zhName
        }
        
        if !enName.isEmpty {
            if !result.isEmpty {
                result += "/"
            }
            result += enName
        }
        return result
    }
    
    required init() {
        
    }
}

class YHMajorInfo: SmartCodable {
    
    var id: Int = 0
    var ch_name: String = ""
    var en_name: String = ""
    
    func getMajorName() -> String {
        var result = ""
        if !ch_name.isEmpty {
            result += ch_name
        }
        if !en_name.isEmpty {
            result += en_name
        }
        return result
    }
    
    required init() {
        
    }
}
