//
//  YHPlanPolicyCarouselView.swift
//  galaxy
//
//  Created by Dufet on 2025/3/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import FSPagerView

class YHPlanPolicyCarouselView: UIView {
    
    var clickBlock: (([YHPlanCaseModel], Int) -> Void)?
    
    var bannerArr: [YHPlanCaseModel] = [] {
        didSet {
            // 设置为0是先停掉自动滑动定时器
            bannerView.automaticSlidingInterval = 0
            self.indicatorView.numberOfPages = self.bannerArr.count
            self.indicatorView.isHidden = self.bannerArr.count <= 1
            bannerView.reloadData()
            // 指定指示器为第一个
            self.indicatorView.currentPage = 0
            // 指定显示图片为第一个
//            bannerView.selectItem(at: 0, animated: false)
            // 开启定时器开始滚动
            bannerView.automaticSlidingInterval = bannerSildingInterval
            bannerView.removesInfiniteLoopForSingleItem = true
            bannerView.alwaysBounceHorizontal = true
        }
    }
    
    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 6.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = .mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_B(ofSize: 18)
        lable.text = "香港政策解读"
        return lable
    }()
    
    lazy var bannerView: FSPagerView = {
        let view = FSPagerView()
        view.delegate = self
        view.dataSource = self
        view.bounces = false
        view.isInfinite = true
        view.automaticSlidingInterval = bannerSildingInterval
        view.register(YHPlanPolicyCarouselImageCell.self, forCellWithReuseIdentifier: YHPlanPolicyCarouselImageCell.cellReuseIdentifier)
        view.itemSize = CGSize(width: KScreenWidth-16.0*4.0, height: 175.0)// FSPagerView.automaticSize
        return view
    }()
    
    lazy var indicatorView: YHPageControl = {
        let pageControl = YHPageControl(frame: .zero)
        let dotHeight = 3.0
        pageControl.spacing = 2.0
        pageControl.dotSize = CGSize(width: 5, height: dotHeight)
        pageControl.selectedDotSize = CGSize(width: 12, height: dotHeight)
        pageControl.numberOfPages = 0
        pageControl.currentPage = 0
        pageControl.dotColor = .init(hex: 0xD5DAE1)
        pageControl.selectedDotColor = .mainTextColor
        return pageControl
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        backgroundColor = .clear
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(bannerView)
        whiteContentView.addSubview(indicatorView)

        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(20)
            make.height.equalTo(25)
        }

        bannerView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(175)
        }
        
        indicatorView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.bottom.equalTo(-10)
            make.height.equalTo(3)
        }
    }

}

extension YHPlanPolicyCarouselView: FSPagerViewDataSource, FSPagerViewDelegate {
    
    public func numberOfItems(in pagerView: FSPagerView) -> Int {
        return self.bannerArr.count
    }
    
    public func pagerView(_ pagerView: FSPagerView, cellForItemAt index: Int) -> FSPagerViewCell {
        guard let cell = pagerView.dequeueReusableCell(withReuseIdentifier: YHPlanPolicyCarouselImageCell.cellReuseIdentifier, at: index) as? YHPlanPolicyCarouselImageCell else {
            return FSPagerViewCell()
        }
        if index < bannerArr.count {
            let model = bannerArr[index]
            cell.model = model
        }
        return cell
    }
    
    // MARK: - FSPagerView Delegate
    func pagerView(_ pagerView: FSPagerView, didSelectItemAt index: Int) {
        pagerView.deselectItem(at: index, animated: true)
        pagerView.scrollToItem(at: index, animated: true)
        if 0 <= index, index < bannerArr.count {
            let model = bannerArr[index]
            clickBlock?(bannerArr, index)
            return
        }
    }
    
    func pagerViewWillEndDragging(_ pagerView: FSPagerView, targetIndex: Int) {
        self.indicatorView.currentPage = targetIndex
    }
    
    func pagerViewDidEndScrollAnimation(_ pagerView: FSPagerView) {
        self.indicatorView.currentPage = pagerView.currentIndex
    }
}
