//
//  YHPlanScoreView.swift
//  galaxy
//
//  Created by Dufet on 2025/3/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanScoreView: UIView {
    
    var model = YHPlanValueChartInfo() {
        didSet {
            let score1 = CGFloat(Double(model.work_score) ?? 0.0)
            let score2 = CGFloat(Double(model.live_score) ?? 0.0)
            let score3 = CGFloat(Double(model.invest_score) ?? 0.0)
            let score4 = CGFloat(Double(model.stay_time_score) ?? 0.0)
            
            chartView.updateScores([score1, score2, score3, score4])
            statusLabel.text = model.level_name
            descLabel.text = model.result
        }
    }

    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 6.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0x6A7586)
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.text = "您的续签评估等级为"
        return lable
    }()
    
    lazy var questionBtn: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "plan_score_level_question"), for: .normal)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 30, left: 30, bottom: 30, right: 30)
        btn.addTarget(self, action: #selector(didQuestionBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var statusLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .center
        lable.font = UIFont(name: "AlibabaPuHuiTi_3_95_ExtraBold", size: 24)
        lable.text = ""
        return lable
    }()
    
    lazy var statusLineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    lazy var chartView: YHPlanScoreChart = {
        let v = YHPlanScoreChart(frame: .zero)
        return v
    }()
    
    lazy var descLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0x6A7586)
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.numberOfLines = 0
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didQuestionBtnClicked() {
        YHPlanScoreLevelTextView.alertView().show()
    }
    
    func createUI() {
        
        backgroundColor = .clear
        
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(questionBtn)
        whiteContentView.addSubview(statusLineView)
        whiteContentView.addSubview(statusLabel)
        whiteContentView.addSubview(chartView)
        whiteContentView.addSubview(descLabel)
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.height.equalTo(18)
            make.top.equalTo(20)
            make.centerX.equalToSuperview().offset(-8)
        }
        
        questionBtn.snp.makeConstraints { make in
            make.width.height.equalTo(14)
            make.centerY.equalTo(titleLabel)
            make.left.equalTo(titleLabel.snp.right).offset(2)
        }
        
        statusLineView.snp.makeConstraints { make in
            make.width.equalTo(64)
            make.height.equalTo(8)
            make.bottom.equalTo(statusLabel.snp.bottom).offset(-2)
            make.centerX.equalToSuperview()
        }
        
        statusLabel.snp.makeConstraints { make in
            make.height.equalTo(34)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
            make.centerX.equalToSuperview()
        }
        
        chartView.snp.makeConstraints { make in
            make.top.equalTo(statusLineView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(268)
        }
        
        descLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(chartView.snp.bottom).offset(20)
            make.bottom.equalTo(-20)
        }
    }

}
