//
//  YHAIThinkingMessageCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Lottie

class YHAIThinkingMessageCell: UITableViewCell {

    static let cellReuseIdentifier = "YHAIThinkingMessageCell"

    var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 12.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var messageLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "港小宝正在思考…"
        return lable
    }()
    
    let loadingImgView: LottieAnimationView! = {
        let lottieView = LottieAnimationView(name: "ai_chat_loading")
        lottieView.loopMode = .loop
        lottieView.contentMode = .scaleAspectFit
        lottieView.play()
        return lottieView
    }()
    
    lazy var shadowView: YHAIChatShadowView = {
        let v = YHAIChatShadowView()
        return v
    }()
    
    var rightAngleView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        return v
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.addSubview(shadowView)
        contentView.addSubview(rightAngleView)
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(messageLabel)
        whiteContentView.addSubview(loadingImgView)
        
        shadowView.snp.makeConstraints { make in
            make.edges.equalTo(whiteContentView)
        }
        
        rightAngleView.snp.makeConstraints { make in
            make.top.left.equalTo(whiteContentView)
            make.width.height.equalTo(15)
        }

        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.lessThanOrEqualTo(-20)
            make.top.equalTo(20)
            make.bottom.equalTo(-20)
        }
        
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(16)
        }
        
        loadingImgView.snp.makeConstraints { make in
            make.left.equalTo(messageLabel)
            make.width.equalTo(26)
            make.height.equalTo(18)
            make.top.equalTo(messageLabel.snp.bottom).offset(6)
            make.bottom.equalTo(-16)
        }
    }
}
