//
//  YHProductListMessageCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHProductListMessageCell: UITableViewCell {

    static let cellReuseIdentifier = "YHProductListMessageCell"
    
    var listModel = YHAIListInfoModel() {
        didSet {
            iconImgView.sd_setImage(with: URL(string: listModel.icon))
            titleLabel.text = listModel.title
            subtitleLabel.text = listModel.description
            listView.removeSubviews()
            var lastItemView: YHProductItemView?
            for (_, item) in listModel.list.enumerated() {
                let productView = YHProductItemView()
                productView.productModel = item
                listView.addSubview(productView)
                productView.snp.makeConstraints { make in
                    make.left.right.equalToSuperview()
                    make.height.equalTo(120)
                    if let lastItemView = lastItemView {
                        make.top.equalTo(lastItemView.snp.bottom)

                    } else {
                        make.top.equalTo(0)
                    }
                }
                lastItemView = productView
            }
            
            if listModel.list.count > 0 {
                if let lastItemView = lastItemView {
                    listView.addSubview(moreBtn)
                    moreBtn.snp.remakeConstraints { make in
                        make.left.right.bottom.equalToSuperview()
                        make.top.equalTo(lastItemView.snp.bottom)
                        make.height.equalTo(40)
                    }
                    moreBtn.iconInRight(with: 0)
                }
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 12.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var iconImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: ""))
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_B(ofSize: 16)
        lable.text = "港小宝"
        return lable
    }()
    
    lazy var subtitleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0x8993A2)
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.text = "为您推荐以下优才产品"
        return lable
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    lazy var listView: UIView = {
        let v = UIView()
        return v
    }()
    
    lazy var moreBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("查看更多", for: .normal)
        btn.setTitleColor(UIColor.init(hex: 0xB9C1CC), for: .normal)
        btn.setImage(UIImage(named: "my_doc_right_arrow"), for: .normal)
        btn.titleLabel?.font = .PFSC_R(ofSize: 12)
        btn.addTarget(self, action: #selector(didMoreButtonClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var shadowView: YHAIChatShadowView = {
        let v = YHAIChatShadowView()
        return v
    }()
    
    @objc func didMoreButtonClicked() {
        UIApplication.shared.yhKeyWindow()?.endEditing(true)
        if let configModel = YHConfigManager.shared.reqVM.configModel, configModel.is_integral_open {
            YHAIJumpPageTool.jumpPageWithType(mode: listModel.redirectMode, path: listModel.redirectPath) {
                _ in
            }
        }
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.addSubview(shadowView)
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(iconImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(subtitleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(listView)
        
        shadowView.snp.makeConstraints { make in
            make.edges.equalTo(whiteContentView)
        }

        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(16)
            make.bottom.equalTo(0)
        }
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(36)
            make.top.equalTo(20)
            make.left.equalTo(16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgView).offset(-4)
            make.left.equalTo(iconImgView.snp.right).offset(8)
            make.height.equalTo(24)
            make.right.equalTo(-16)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel)
            make.top.equalTo(titleLabel.snp.bottom).offset(0)
            make.height.equalTo(20)
            make.right.equalTo(-16)
        }
        lineView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(subtitleLabel.snp.bottom).offset(10)
            make.height.equalTo(0.5)
        }
        
        listView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(lineView.snp.bottom).offset(0)
            make.bottom.equalTo(0)
        }
    }
}
