//
//  BsBannerModel.swift
//  BaiSiSMApp
//
//  Created by DAVID on 2022/11/16.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import Foundation
import SmartCodable

class YHBannerModel: SmartCodable {
    var name: String = ""
    var skip_url: String = ""
    var img_url: String = ""
    var type: Int = 0// banner 跳转类型：0-不跳转，1-跳转H5，2-跳转APP内Tab，3-跳转资讯页  100  101
    var create_at: String = ""
    var skip_type: Int = 0
    var id: Int = 0
    var img_url_compress: String = ""
    var media_type: Int = 1 // 投放类型：1 图片，2 直播
    var live_id: Int = 0    // 直播ID
    var live_status: Int = 0 // 直播状态 1:直播中 2:未直播 0:未知状态 3:结束直播
    var live_type: Int = 0  // 播放类型：1 展示最新直播，2指定直播，3 指定录播
    var live_pull_url: String = "" // 直播拉流链接
    var video_url: String = "" // 视频链接
    var recorded_video_id: Int = 0 // 录播分类ID
    var app_id: String = "" // 声网直播
    var token: String = "" // 声网直播
    var rtmp_channel: String = "" // 声网直播
    var user_id: Int = 0
    var is_full_screen: Bool? // 是否通屏
    // 是否为本地
    var isLocalItemFlag: Bool = false
    
    // 分享相关参数
    var is_share_h5_flag: Bool = false
    var addtition_param: YHBannerAdditionModel?
    // 是否为双11活动
    var is_double_11_flag: Bool = false
    required init() {
    }
    
    //
    static func localDefaultItem() -> YHBannerModel {
        let model = YHBannerModel()
        model.isLocalItemFlag = true
        model.img_url = "home_banner_default_icon"
        model.type = 0
        return model
    }
}

class YHBannerAdditionModel: SmartCodable {
    var ShareH5Title: String = ""
    var ShareH5Describe: String = ""
    var ShareH5Url: String = ""
    
    required init() {
    }
}
