//
//  YHHomeWebBottomButton.swift
//  galaxy
//
//  Created by EDY on 2024/4/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeWebBottomButton: UIButton {

    var topImageView: UIImageView!
    var bottomTitleLabel: UILabel!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        topImageView = {
            let view = UIImageView()
            return view
        }()
        addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.top.centerX.equalToSuperview()
            make.width.height.equalTo(24)
        }
        
        bottomTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 11)
            label.textAlignment = .center
            label.textColor = UIColor.mainTextColor
            return label
        }()
        addSubview(bottomTitleLabel)
        bottomTitleLabel.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(15)
        }
    }
    
    func setContent(_ image: UIImage?, _ title: String) {
        bottomTitleLabel.text = title
        topImageView.image = image
    }
    /*
    // Only override draw() if you perform custom drawing.
    // An empty implementation adversely affects performance during animation.
    override func draw(_ rect: CGRect) {
        // Drawing code
    }
    */

}
