//
//  YHPayMembersCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHPayMembersCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHPayMembersCell"
    
    var dataModel: YHVisaPaymentListModel? {
        didSet {
            updataUI()
        }
    }
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        view.backgroundColor = .white
        return view
    }()
    
    lazy var tipsLable: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.textColor = UIColor.yhGreyColor
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.text = "温馨提示：若此处缴费状态和港府官网显示不一致，可能存在延迟更新状态，可尝试更新缴费结果，缴费状态以港府为准"
        return label
    }()
    
    // 用来自动布局
    lazy var fakeView: UIView = {
        let view = UIView()
        return view
    }()
    
    private var arrOtherView: [UIView] = []
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
}

private extension YHPayMembersCell {
    func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        
        whiteContentView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        //
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.text = "缴费成员"
        
        whiteContentView.addSubview(label)
        label.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.left.equalTo(kMargin)
            make.height.equalTo(24)
        }
        
        let line = UIView()
        line.backgroundColor = .separatorColor
        whiteContentView.addSubview(line)
        
        line.snp.makeConstraints { make in
            make.top.equalTo(label.snp.bottom).offset(12)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(1)
        }
        
        whiteContentView.addSubview(tipsLable)
        tipsLable.snp.makeConstraints { make in
            make.top.equalTo(line.snp.bottom).offset(kMargin)
            make.left.equalTo(kMargin)
            make.right.equalToSuperview().offset(-kMargin)
        }
        
        let a: ASAttributedString = .init("温馨提示：若此处缴费状态和港府官网显示不一致，可能存在延迟更新状态，", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.yhGreyColor))
        let aa: ASAttributedString = .init(NSAttributedString(string: "可尝试更新缴费结果"), .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.brandMainColor))
        let aaa: ASAttributedString = .init("，缴费状态以港府为准", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.yhGreyColor))
        tipsLable.attributed.text = a + aa + aaa
        
        whiteContentView.addSubview(fakeView)
        fakeView.snp.makeConstraints { make in
            make.top.equalTo(tipsLable.snp.bottom).offset(kMargin)
            make.left.equalTo(kMargin)
            make.right.equalToSuperview().offset(-kMargin)
            
            make.bottom.equalToSuperview()
        }
    }
}

private extension YHPayMembersCell {
    func updataUI() {
        guard let model = dataModel, model.list.count > 0 else { return }
        
        for (_, item) in arrOtherView.enumerated() {
            item.removeFromSuperview()
        }
        arrOtherView.removeAll()
        
        fakeView.snp.removeConstraints()
        
        var lastView: UIView = tipsLable
        for (index, item) in model.list.enumerated() {
            let view = YHPayMemberItemsView()
            whiteContentView.addSubview(view)
            view.snp.makeConstraints { make in
                make.top.equalTo(lastView.snp.bottom).offset(20)
                make.left.equalTo(kMargin)
                make.right.equalToSuperview().offset(-kMargin)
            }
            view.dataModel = item
            lastView = view
            
            view.isLastFlag = (index == model.list.count - 1) ? true : false
            
            arrOtherView.append(view)
        }
        
        fakeView.snp.makeConstraints { make in
            make.top.equalTo(lastView.snp.bottom)
            make.left.equalTo(kMargin)
            make.right.equalToSuperview().offset(-kMargin)
            make.height.equalTo(1)
            
            make.bottom.equalToSuperview()
        }
    }
}
