//
//  YHResultBottomView.swift
//  galaxy
//
//  Created by EDY on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResultBottomView: UIView {

    typealias Block = () -> Void
    var nextblock: Block?
    var nextButton: UIButton!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        nextButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.backgroundColor = UIColor.brandMainColor
            button.contentHorizontalAlignment = .center
            button.setTitle("开始识别", for: .normal)
            button.setImage(UIImage(named: "image_scan"), for: .normal)
            button.setTitleColor(UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.iconInLeft(spacing: 6)
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goNext), for: .touchUpInside)
            return button
        }()
        addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.top.equalTo(10)
            make.height.equalTo(44)
            make.left.equalTo(16)
        }
        
//        nextButton.layoutIfNeeded()
//        nextButton.backgroundGradient()
//        nextButton.addYinHeGradualLayer()
    }
    
    @objc func goNext() {
        if let block = nextblock {
            block()
        }
    }
}
