//
//  YHMainChannelDelegate.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/3.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import AgoraRtcKit
import UIKit

// MARK: - Channel Delegates

class YHMainChannelDelegate: NSObject, AgoraRtcEngineDelegate {
    var channelId: String?
    weak var player: YHPlayer?
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, didJoinedOfUid uid: UInt, elapsed: Int) {
        guard let channelId = channelId,
              let player = player,
              let view = player.currentPlayView else { return }

        printLog("$$$$###main channel: remote user join room \(channelId): \(uid) \(elapsed)ms")

        let videoCanvas = AgoraRtcVideoCanvas()
        videoCanvas.uid = uid
        videoCanvas.view = view
        videoCanvas.renderMode = .fit
        engine.setupRemoteVideo(videoCanvas)
    }

    func rtcEngine(_ engine: AgoraRtcEngineKit, didOfflineOfUid uid: UInt, reason: AgoraUserOfflineReason) {
        // printLog("$$$$###main channel: remote user left: \(uid) reason \(reason)")
        let videoCanvas = AgoraRtcVideoCanvas()
        videoCanvas.uid = uid
        videoCanvas.view = nil
        videoCanvas.renderMode = .hidden
        engine.setupRemoteVideo(videoCanvas)
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, videoSizeChangedOf sourceType: AgoraVideoSourceType, uid: UInt, size: CGSize, rotation: Int) {
        // printLog("$$$$###videoSizeChangedOf: \(size)")
        if let player = player {
            player.delegate?.player(player, didReceiveVideoSize: size)
        }
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, remoteVideoStats stats: AgoraRtcRemoteVideoStats) {
        // printLog("$$$$###remoteVideoStats FrameRate: \(stats) receivedBitrate: \(stats.receivedBitrate), receivedFrameRate: \(stats.receivedFrameRate)")
        if let player = player {
            player.delegate?.player(player, remoteVideoStats: stats)
        }
    }
    /*
    func rtcEngine(_ engine: AgoraRtcEngineKit, didJoinChannel channel: String, withUid uid: UInt, elapsed: Int) {
        //printLog("$$$$###main channel: local user join room \(channelId ?? ""): \(uid) \(elapsed)ms")
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, firstRemoteVideoFrameOfUid uid: UInt, size: CGSize, elapsed: Int) {
        printLog("$$$$###firstRemoteVideoFrameOfUid: \(size)")
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, didOccurError errorCode: AgoraErrorCode) {
        printLog("$$$$###didOccurError: \(errorCode)")
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, didLeaveChannelWith stats: AgoraChannelStats) {
        printLog("$$$$###didLeaveChannelWith \(stats)")
    }
    
    func rtcEngineVideoDidStop(_ engine: AgoraRtcEngineKit) {
        printLog("$$$$###rtcEngineVideoDidStop")
    }
    
    func rtcEngineConnectionDidInterrupted(_ engine: AgoraRtcEngineKit) {
        printLog("$$$$###rtcEngineConnectionDidInterrupted")
    }
    
    func rtcEngineConnectionDidLost(_ engine: AgoraRtcEngineKit) {
        printLog("$$$$###rtcEngineConnectionDidLost")
    }
    */
}

class YHSecondaryChannelDelegate: NSObject, AgoraRtcEngineDelegate {
    var channelId: String?
    weak var player: YHPlayer?
    func rtcEngine(_ engine: AgoraRtcEngineKit, didJoinedOfUid uid: UInt, elapsed: Int) {
        guard let channelId = channelId,
              let player = player,
              let view = player.currentPlayView else { return }
        // printLog("$$$$###secondary channel: remote user join room \(channelId): \(uid) \(elapsed)ms")
        let videoCanvas = AgoraRtcVideoCanvas()
        videoCanvas.uid = uid
        videoCanvas.view = view
        videoCanvas.renderMode = .fit

        let connection = AgoraRtcConnection()
        connection.channelId = channelId
        connection.localUid = player.currentUid ?? 0
        engine.setupRemoteVideoEx(videoCanvas, connection: connection)
    }

    func rtcEngine(_ engine: AgoraRtcEngineKit, didOfflineOfUid uid: UInt, reason: AgoraUserOfflineReason) {
        guard let channelId = channelId,
              let player = player else { return }
        // printLog("$$$$###secondary channel: remote user left: \(uid) reason \(reason)")
        let videoCanvas = AgoraRtcVideoCanvas()
        videoCanvas.uid = uid
        videoCanvas.view = nil
        videoCanvas.renderMode = .hidden

        let connection = AgoraRtcConnection()
        connection.channelId = channelId
        connection.localUid = player.currentUid ?? 0
        engine.setupRemoteVideoEx(videoCanvas, connection: connection)
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, videoSizeChangedOf sourceType: AgoraVideoSourceType, uid: UInt, size: CGSize, rotation: Int) {
        // printLog("$$$$###videoSizeChangedOf: \(size)")
        if let player = player {
            player.delegate?.player(player, didReceiveVideoSize: size)
        }
    }
    func rtcEngine(_ engine: AgoraRtcEngineKit, remoteVideoStats stats: AgoraRtcRemoteVideoStats) {
        // printLog("$$$$###remoteVideoStats FrameRate: \(stats) receivedBitrate: \(stats.receivedBitrate), receivedFrameRate: \(stats.receivedFrameRate)")
        if let player = player {
            player.delegate?.player(player, remoteVideoStats: stats)
        }
    }
    /*
    func rtcEngine(_ engine: AgoraRtcEngineKit, didJoinChannel channel: String, withUid uid: UInt, elapsed: Int) {
        printLog("$$$$###secondary channel: local user join room \(channelId ?? ""): \(uid) \(elapsed)ms")
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, firstRemoteVideoFrameOfUid uid: UInt, size: CGSize, elapsed: Int) {
        printLog("$$$$###firstRemoteVideoFrameOfUid: \(size)")
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, didOccurError errorCode: AgoraErrorCode) {
        printLog("$$$$###didOccurError: \(errorCode)")
    }
    
    func rtcEngine(_ engine: AgoraRtcEngineKit, didLeaveChannelWith stats: AgoraChannelStats) {
        printLog("$$$$###didLeaveChannelWith \(stats)")
    }
    
    func rtcEngineVideoDidStop(_ engine: AgoraRtcEngineKit) {
        printLog("$$$$###rtcEngineVideoDidStop")
    }
    
    func rtcEngineConnectionDidInterrupted(_ engine: AgoraRtcEngineKit) {
        printLog("$$$$###rtcEngineConnectionDidInterrupted")
    }
    
    func rtcEngineConnectionDidLost(_ engine: AgoraRtcEngineKit) {
        printLog("$$$$###rtcEngineConnectionDidLost")
    }
    */
}
