//
//  YHEditWorkViewController.swift
//  galaxy
//
//  Created by EDY on 2024/6/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHEditWorkViewController: YHBaseViewController {
    var nextButton: UIButton!
    var tableView: UITableView!
    var items: [YHUserInformationModel] = []
    var viewModel: YHEditViewModel = YHEditViewModel()
    var model: YHUserNameCardInfo = YHUserNameCardInfo()

    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        getData()
    }
    
    func getData() {
        viewModel.model = model
        items = viewModel.getBaseWorkDataSource()
        tableView.reloadData()
        if self.viewModel.isCanNext(step: 4) {
            nextButton.isEnabled = true
            nextButton.backgroundColor =  UIColor.brandGrayColor8
        } else {
            nextButton.isEnabled = false
            nextButton.backgroundColor =  UIColor.brandGrayColor4
        }
    }
    
    func setView() {
        gk_navTitle = "工作经历"
        view.backgroundColor = .white
    
        nextButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandGrayColor8
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("保存", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(nextStep), for: .touchUpInside)
            return button
        }()
        view.addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-8 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(48)
        }
        
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.backgroundColor = .white
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHMyInformationItemCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 64 - 36)
            make.left.right.equalTo(view)
        }
    }
    
    @objc func nextStep() {
        viewModel.requestSaveWork {[weak self] success, _ in
            guard let self = self else { return }
            if success {
                self.navigationController?.popViewController(animated: true)
            } else {
                YHHUD.flash(message: "保存失败")
            }
        }
    }
    
    override func backItemClick(_ sender: Any) {
        if viewModel.didChange {
            view.resignAllFirstResponders()
            YHGrayCommonAlertView.show("", "您尚未保存修改，确定关闭吗？", "仍然关闭", "继续编辑", fullGuestureEnable: false) {
                self.navigationController?.popViewController()
            } callBack: {
            }
        } else {
            self.navigationController?.popViewController()
        }
    }
    
    /// 是否可以返回，包括点击返回和手势返回，默认YES
    override func navigationShouldPop() -> Bool {
        if viewModel.didChange {
            view.resignAllFirstResponders()
            YHGrayCommonAlertView.show("", "您尚未保存修改，确定关闭吗？", "仍然关闭", "继续编辑", fullGuestureEnable: false) {
                self.navigationController?.popViewController()
            } callBack: {
            }
            return false
        }
        return true
    }
}

extension YHEditWorkViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHMyInformationItemCell.self)
        cell.dataSource = items[indexPath.row]
        cell.block = { [weak self] model in
            guard let self = self else { return }
            self.viewModel.updateModel(model)
            if model.id != .id5 && model.id != .id10 {
                self.getData()
            }
            if self.viewModel.isCanNext(step: 4) {
                nextButton.isEnabled = true
                nextButton.backgroundColor =  UIColor.brandGrayColor8
            } else {
                nextButton.isEnabled = false
                nextButton.backgroundColor =  UIColor.brandGrayColor4
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 61.0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 0.01))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
}
