//
//  YHEditBaseInfoFootView.swift
//  galaxy
//
//  Created by EDY on 2024/6/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHEditBaseInfoFootView: UIView {
    typealias MessageBlock = (_ message: String) -> Void
    var messageBlock: MessageBlock?
    var titleLabel: UILabel!
    var messageTextField: UITextView!
    var promptsLabel: UILabel!
    var numberLabel: UILabel!
    var dataSource: String? {
        didSet {
            updateAllViews()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    func setupUI() {
        backgroundColor = .white
        
        titleLabel = {
            let label = UILabel()
            let str = "个性签名"
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 15),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            label.attributedText = questionAttrStr
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.top.equalTo(20)
            make.height.equalTo(21)
            make.width.equalTo(70)
        }
        
        let bgView = UIView()
        bgView.backgroundColor = UIColor.contentBkgColor
        bgView.layer.masksToBounds = true
        bgView.layer.cornerRadius = 6
        addSubview(bgView)
        bgView.snp.makeConstraints { make in
            make.left.equalTo(113)
            make.right.equalTo(-19)
            make.top.equalTo(23)
            make.height.equalTo(108)
        }
        
        messageTextField = {
            let textField = UITextView()
            textField.backgroundColor = .clear
            textField.font = UIFont.PFSC_R(ofSize: 15)
            textField.delegate = self
            return textField
        }()
        addSubview(messageTextField)
        messageTextField.snp.makeConstraints { make in
            make.left.equalTo(124)
            make.right.equalTo(-37)
            make.top.equalTo(30)
            make.height.equalTo(80)
        }
    
        promptsLabel = {
            let prompts = UILabel()
            prompts.font = UIFont.PFSC_R(ofSize: 14)
            prompts.textColor = UIColor.brandGrayColor5
            prompts.text = "填写个性签名，展现真我风采，彰显独特身份"
            prompts.numberOfLines = 0
            return prompts
        }()
        addSubview(promptsLabel)
        promptsLabel.snp.makeConstraints { make in
            make.left.equalTo(129)
            make.right.equalTo(-37)
            make.top.equalTo(35)
        }
        
        numberLabel = {
            let view = UILabel()
            view.text = "--/20"
            view.font = UIFont.PFSC_R(ofSize: 14)
            view.textColor = UIColor.placeHolderColor
            view.textAlignment = .right
            return view
        }()
        addSubview(numberLabel)
        numberLabel.snp.makeConstraints { make in
            make.height.equalTo(16)
            make.right.equalTo(-37)
            make.top.equalTo(101)
        }
    }
    
    func updateAllViews() {
        messageTextField.text = dataSource
        if dataSource?.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
        numberLabel.text = messageTextField.text.count.string + "/20"
    }
}

extension YHEditBaseInfoFootView: UITextViewDelegate {
    func textViewDidChange(_ textView: UITextView) {
        if textView.text.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
        if let block = messageBlock {
            block(textView.text ?? "")
        }
        numberLabel.text = textView.text.count.string + "/20"
    }
    
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        let newLength = (textView.text as NSString).length + text.count - range.length
        
        return newLength <= 20
    }
}
