//
//  YHMakePlanShareAlertView.swift
//  galaxy
//
//  Created by EDY on 2025/3/29.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMakePlanShareAlertView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    var centerView: UIView!
    var sureButton: UIButton!
    var leftButton: YHShareButton!
    var rightButton: YHShareButton!
    var url: String = ""
    static func show(url: String, callBack: @escaping ((Int) -> Void)) {
        let view = YHMakePlanShareAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.block = callBack
        view.url = url
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(216)
        }
        
        sureButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor = UIColor(hex: 0xf5f6f8)
            button.setTitleColor(.mainTextColor, for: .normal)
            button.setTitle("取消", for: .normal)
            button.layer.cornerRadius = 4
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(sureButton)
        sureButton.snp.makeConstraints { make in
            make.bottom.equalTo(-54)
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(46)
        }

        leftButton = {
            let button = YHShareButton()
            button.setContent("invitation_with_gifts_share_center", "微信好友")
            button.bottomTitleLabel.font = UIFont.PFSC_R(ofSize: 13)
            button.addTarget(self, action: #selector(peopleClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(leftButton)
        leftButton.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.right.equalTo(centerView.snp.centerX).offset(-33)
            make.height.equalTo(74)
            make.width.equalTo(52)
        }
        
        rightButton = {
            let button = YHShareButton()
            button.setContent("invitation_with_gifts_share_link", "复制链接")
            button.bottomTitleLabel.font = UIFont.PFSC_R(ofSize: 13)
            button.addTarget(self, action: #selector(wxClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(rightButton)
        rightButton.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.left.equalTo(centerView.snp.centerX).offset(33)
            make.height.equalTo(74)
            make.width.equalTo(52)
        }
    }
    
    @objc func wxClick() {
        if let url = URL(string: url) {
            UIPasteboard.general.url = url
            YHHUD.flash(message: "复制成功")
        }
    }
    
    @objc func peopleClick() {
        YHShareManager.shared.sendLinkContent("香港续签至永居方案定制", "银河为您私人定制全套方案，快来试试吧~", UIImage(named: "invitation_with_gifts_share_plan") ?? UIImage(), link: url)
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func orderButtonClick() {
        if let block = block {
            block(1)
        }
        dismiss()
    }
    
    @objc func guideButtonClick() {
        if let block = block {
            block(2)
        }
        dismiss()
    }
}

extension YHMakePlanShareAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
