//
//  YHPlanScoreCell.swift
//  galaxy
//
//  Created by Dufet on 2025/3/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanScoreCell: UITableViewCell {

    static let cellReuseIdentifier = "YHPlanScoreCell"
    
    var model = YHPlanValueChartInfo() {
        didSet {
            scoreView.model = model
        }
    }

    lazy var scoreView: YHPlanScoreView = {
        let v = YHPlanScoreView(frame: .zero)
        return v
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        self.contentView.addSubview(scoreView)
        scoreView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}
