//
//  UIButton-Extension.swift
//  BaiSiSMApp
//
//  Created by Davidhuang on 2023/1/11.
//  Copyright © 2023 www.sumian.com. All rights reserved.
//

import UIKit

extension UIButton {
    
    /// 图片在右位置
    /// - Parameter spacing: 间距
    func iconInRight(with spacing: CGFloat) {
        let img_w = self.imageView?.frame.size.width ?? 0
        let title_w = self.titleLabel?.frame.size.width ?? 0
        
        self.titleEdgeInsets = UIEdgeInsets(top: 0, left: -(img_w+spacing / 2.0), bottom: 0, right: (img_w+spacing / 2.0))
        self.imageEdgeInsets = UIEdgeInsets(top: 0, left: (title_w+spacing / 2.0), bottom: 0, right: -(title_w+spacing / 2.0))
    }
    
    /// 图片在左位置
    /// - Parameter spacing: 间距
    func iconInLeft(spacing: CGFloat) {
        self.titleEdgeInsets = UIEdgeInsets(top: 0, left: spacing / 2.0, bottom: 0, right: -spacing / 2.0)
        self.imageEdgeInsets = UIEdgeInsets(top: 0, left: -spacing / 2.0, bottom: 0, right: spacing / 2.0)
    }
    
    /// 图片在上面
    /// - Parameter spacing: 间距
    func iconInTop(spacing: CGFloat) {
        let img_W = self.imageView?.frame.size.width ?? 0
        let img_H = self.imageView?.frame.size.height ?? 0
        let tit_W = self.titleLabel?.frame.size.width ?? 0
        let tit_H = self.titleLabel?.frame.size.height ?? 0
        
        self.titleEdgeInsets = UIEdgeInsets(top: (tit_H / 2 + spacing / 2), left: -(img_W / 2), bottom: -(tit_H / 2 + spacing / 2), right: (img_W / 2))
        self.imageEdgeInsets = UIEdgeInsets(top: -(img_H / 2 + spacing / 2), left: (tit_W / 2), bottom: (img_H / 2 + spacing / 2), right: -(tit_W / 2))
    }
    
    /// 图片在 下面
    /// - Parameter spacing: 间距
    func iconInBottom(spacing: CGFloat) {
        let img_W = self.imageView?.frame.size.width ?? 0
        let img_H = self.imageView?.frame.size.height ?? 0
        let tit_W = self.titleLabel?.frame.size.width ?? 0
        let tit_H = self.titleLabel?.frame.size.height ?? 0
        
        self.titleEdgeInsets = UIEdgeInsets(top: -(tit_H / 2 + spacing / 2), left: -(img_W / 2), bottom: (tit_H / 2 + spacing / 2), right: (img_W / 2))
        self.imageEdgeInsets = UIEdgeInsets(top: (img_H / 2 + spacing / 2), left: (tit_W / 2), bottom: -(img_H / 2 + spacing / 2), right: -(tit_W / 2))
    }
}

// MARK: - Create 初始化
extension UIButton {
    
    public class func bs_button(
        title: String? = nil,
        selectTitle: String? = nil,
        font: UIFont? = nil,
        normalColor: UIColor? = nil,
        selectColor: UIColor? = nil,
        bgNormalColor: UIColor? = nil,
        bgSelectColor: UIColor? = nil,
        lightNormalColor: UIColor? = nil,
        lightSelectColor: UIColor? = nil,
        bgLightNormalColor: UIColor? = nil,
        bgLightSelectColor: UIColor? = nil) -> UIButton {
            
            let btn = UIButton(type: .custom)
            btn.titleLabel?.font = font
            
            btn.setTitle(title, for: .normal)
            btn.setTitle(selectTitle, for: .selected)
            btn.setTitle(title, for: [.highlighted, .normal])
            btn.setTitle(selectTitle, for: [.highlighted, .selected])
            
            btn.setTitleColor(normalColor, for: .normal)
            btn.setTitleColor(selectColor, for: .selected)
            btn.setTitleColor(lightNormalColor, for: [.highlighted, .normal])
            btn.setTitleColor(lightSelectColor, for: [.highlighted, .selected])
            
            btn.setBackgroundImage(bgNormalColor?.toImage(), for: .normal)
            btn.setBackgroundImage(bgSelectColor?.toImage(), for: .selected)
            btn.setBackgroundImage(bgLightNormalColor?.toImage(), for: [.highlighted, .normal])
            if bgLightNormalColor == nil {
                btn.setBackgroundImage(bgNormalColor?.withAlphaComponent(0.9).toImage(), for: [.highlighted, .normal])
            }
            btn.setBackgroundImage(bgLightSelectColor?.toImage(), for: [.highlighted, .selected])
            if bgLightSelectColor == nil {
                btn.setBackgroundImage(bgSelectColor?.withAlphaComponent(0.9).toImage(), for: [.highlighted, .selected])
            }
            
            return btn
        }
}

// 扩大点击范围
extension UIButton {
    
    private struct RuntimeKey {
        static let clickEdgeInsets = UnsafeRawPointer.init(bitPattern: "clickEdgeInsets".hashValue)
    }
    
    /// 需要扩充的点击边距
    public var YH_clickEdgeInsets: UIEdgeInsets? {
        set {
            objc_setAssociatedObject(self, UIButton.RuntimeKey.clickEdgeInsets!, newValue, objc_AssociationPolicy.OBJC_ASSOCIATION_COPY)
        }
        get {
            return objc_getAssociatedObject(self, UIButton.RuntimeKey.clickEdgeInsets!) as? UIEdgeInsets ?? UIEdgeInsets.zero
        }
    }
    
    // 重写系统方法修改点击区域
    open override func point(inside point: CGPoint, with event: UIEvent?) -> Bool {
        super.point(inside: point, with: event)
        var bounds = self.bounds
        if YH_clickEdgeInsets != nil {
            let x: CGFloat = -(YH_clickEdgeInsets?.left ?? 0)
            let y: CGFloat = -(YH_clickEdgeInsets?.top ?? 0)
            let width: CGFloat = bounds.width + (YH_clickEdgeInsets?.left ?? 0) + (YH_clickEdgeInsets?.right ?? 0)
            let height: CGFloat = bounds.height + (YH_clickEdgeInsets?.top ?? 0) + (YH_clickEdgeInsets?.bottom ?? 0)
            bounds = CGRect(x: x, y: y, width: width, height: height) // 负值是方法响应范围
        }
        return bounds.contains(point)
    }
}
