//
//  YHContact.swift
//  galaxy
//
//  Created by Dufet on 2025/9/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHContactListModel: SmartCodable {
    var total: Int = 0
    var list: [YHContact] = []
    
    required init() {
        
    }
}

enum YHContactRelation: Int {
    case stranger = 1   //  陌生人
    case unvalidate = 3 // 待验证
    case friend = 5 // 好友
}

// 联系人数据模型
class YHContact: SmartCodable {
    var id: String = ""
    var yh_id: String = ""
    var username: String = ""
    var avatar: String = ""
    var position: String = ""
    var industry: String = ""
    var signature: String = ""
    var bio: String = ""
    var type: Int = 1  // 人脉状态 1: 陌生人  3: 待验证  5: 好友

    required init() {
        
    }
}
