//
//  YHConversationGuideView.swift
//  galaxy
//
//  Created by alexzzw on 2025/1/9.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHConversationGuideView: UIView {
    
    var checkButtonEvent: (() -> Void)?
    
    private lazy var centerView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        return view
    }()
    
    private lazy var bottomContainerView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.clipsToBounds = true
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()

    private lazy var topImageView: UIImageView = {
        let imageV  = UIImageView()
        imageV.image = UIImage(named: "conversation_guide_icon")
        imageV.contentMode = .scaleToFill
        imageV.clipsToBounds = true
        imageV.isUserInteractionEnabled = true
        return imageV
    }()
    
    lazy var checkButton: UIButton = {
        let button = UIButton(type: .custom)
        button.addTarget(self, action: #selector(clickCheckButton), for: .touchUpInside)
        button.setTitle("立即查看", for: .normal)
        button.setTitleColor(.white, for: .normal)
        button.backgroundColor = .brandMainColor
        button.layer.cornerRadius = 3
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        return button
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label: UILabel = UILabel()
        label.text = "您好！银河用户"
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        return label
    }()
    
    private lazy var infoContentLabel: UILabel = {
        let label: UILabel = UILabel()
        label.text = "我是您的专属文案管家，为您提供最贴心的帮助与引导，请随时告诉我您的需求"
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = UIColor(hexString: "#4D5665")
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        label.textAlignment = .center
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        addSubview(centerView)
        centerView.addSubview(bottomContainerView)
        centerView.addSubview(topImageView)
        bottomContainerView.addSubview(checkButton)
        bottomContainerView.addSubview(infoTitleLabel)
        bottomContainerView.addSubview(infoContentLabel)
        centerView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(38)
            make.right.equalToSuperview().offset(-38)
            make.centerY.equalToSuperview()
        }
        let ratio = 299.0 / 152.0
        
        topImageView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.width.equalTo(topImageView.snp.height).multipliedBy(ratio)
        }
        bottomContainerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(topImageView.snp.centerY)
        }
        infoTitleLabel.snp.makeConstraints { make in
            make.top.equalTo(topImageView.snp.bottom).offset(24)
            make.left.greaterThanOrEqualToSuperview()
            make.right.lessThanOrEqualToSuperview()
            make.centerX.equalToSuperview()
        }
        infoContentLabel.snp.makeConstraints { make in
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(6)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
        }
        checkButton.snp.makeConstraints { make in
            make.top.equalTo(infoContentLabel.snp.bottom).offset(32)
            make.left.right.equalTo(infoContentLabel)
            make.height.equalTo(45)
            make.bottom.equalToSuperview().offset(-16)
        }
    }
    
    @objc private func clickCheckButton() {
        checkButtonEvent?()
        dismiss()
    }
    
    func show() {
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(self)
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}

extension YHConversationGuideView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
