//
//  YHActivitySignSuccessViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivitySignSuccessViewController: YHBaseViewController {
    
    private let tableView = UITableView(frame: .zero, style: .grouped)
    private var hasPrize: Bool = false
    private var prize: Prize?
    private var event: CheckInEvent?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        setupWithPrize() // 切换到 setupWithoutPrize() 查看无奖品情况
    }
    
    private func setupUI() {
        view.backgroundColor = UIColor(red: 0.85, green: 0.90, blue: 0.95, alpha: 1)
        tableView.delegate = self
        tableView.dataSource = self
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.register(YHSignPrizeCell.self, forCellReuseIdentifier: YHSignPrizeCell.cellReuseIdentifier)
        tableView.register(YHSignActivityInfoCell.self, forCellReuseIdentifier: YHSignActivityInfoCell.cellReuseIdentifier)
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.bottom.equalToSuperview()
        }
    }
    
    // 有奖品的情况
    private func setupWithPrize() {
        hasPrize = true
        prize = Prize(
            greeting: "你好，侯林先生",
            instruction: "请联系现场工作人员领取您的奖品",
            image: "prize_sofa"
        )
        event = CheckInEvent(
            title: "翱翔云端·探索无限",
            subtitle: "2025无人机创新科技沙龙",
            date: "2025-09-13  周六  09:30",
            location: "银河集团香港体验中心（香港湾仔港湾道26号华润大厦27楼2705室）",
            subLocation: "请于机导航至银河集团香港体验中心",
            thumbnailImage: "event_thumb"
        )
        tableView.reloadData()
    }
    
    // 无奖品的情况
    private func setupWithoutPrize() {
        hasPrize = false
        prize = nil
        event = CheckInEvent(
            title: "翱翔云端·探索无限",
            subtitle: "2025无人机创新科技沙龙",
            date: "2024-08-06  周日  09:30",
            location: "本元大厦26A银河集团体验中心",
            subLocation: "距地铁10号线亮马站D口步行62",
            thumbnailImage: "event_thumb"
        )
        tableView.reloadData()
    }
}

// MARK: - UITableViewDelegate & DataSource
extension YHActivitySignSuccessViewController: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if hasPrize {
            return 2 // 标题 + 奖品 + 活动信息
        } else {
            return 1 // 标题 + 活动信息
        }
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if hasPrize {
            if indexPath.row == 0 {
                // 奖品 Cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignPrizeCell.cellReuseIdentifier, for: indexPath) as? YHSignPrizeCell else {
                    return UITableViewCell()
                }
                if let prize = prize {
                    cell.configure(with: prize)
                }
                return cell
            } else {
                // 活动信息 Cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignActivityInfoCell.cellReuseIdentifier, for: indexPath) as? YHSignActivityInfoCell else {
                    return UITableViewCell()
                }
                if let event = event {
                    cell.configure(with: event)
                }
                return cell
            }
        } else {
            // 无奖品时，第二个就是活动信息 Cell
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignActivityInfoCell.cellReuseIdentifier, for: indexPath) as? YHSignActivityInfoCell else {
                return UITableViewCell()
            }
            if let event = event {
                cell.configure(with: event)
            }
            return cell
        }
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = YHSignSuccessHeaderView()
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 83
    }
}
