//
//  YHSignSuccessCell.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSignActivityInfoCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHSignActivityInfoCell"
    
    private let containerView = UIView()
    private let titleLabel = UILabel()
    private let subtitleLabel = UILabel()
    private let thumbnailImageView = UIImageView()
    private let timeLabel = UILabel()
    private let timeValueLabel = UILabel()
    private let locationLabel = UILabel()
    private let locationValueLabel = UILabel()
    private let subLocationLabel = UILabel()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        backgroundColor = .clear
        selectionStyle = .none
        
        containerView.backgroundColor = UIColor(white: 0.98, alpha: 1)
        containerView.layer.cornerRadius = 12
        contentView.addSubview(containerView)
        
        titleLabel.font = .systemFont(ofSize: 16, weight: .medium)
        titleLabel.textColor = .black
        titleLabel.numberOfLines = 0
        containerView.addSubview(titleLabel)
        
        subtitleLabel.font = .systemFont(ofSize: 16, weight: .medium)
        subtitleLabel.textColor = .black
        subtitleLabel.numberOfLines = 0
        containerView.addSubview(subtitleLabel)
        
        thumbnailImageView.contentMode = .scaleAspectFit
        thumbnailImageView.layer.cornerRadius = 4
        thumbnailImageView.clipsToBounds = true
        thumbnailImageView.backgroundColor = .systemBlue.withAlphaComponent(0.2)
        containerView.addSubview(thumbnailImageView)
        
        timeLabel.text = "时间"
        timeLabel.font = .systemFont(ofSize: 14)
        timeLabel.textColor = .gray
        containerView.addSubview(timeLabel)
        
        timeValueLabel.font = .systemFont(ofSize: 14)
        timeValueLabel.textColor = .black
        timeValueLabel.numberOfLines = 0
        containerView.addSubview(timeValueLabel)
        
        locationLabel.text = "地点"
        locationLabel.font = .systemFont(ofSize: 14)
        locationLabel.textColor = .gray
        containerView.addSubview(locationLabel)
        
        locationValueLabel.font = .systemFont(ofSize: 14)
        locationValueLabel.textColor = .black
        locationValueLabel.numberOfLines = 0
        containerView.addSubview(locationValueLabel)
        
        subLocationLabel.font = .systemFont(ofSize: 12)
        subLocationLabel.textColor = .lightGray
        subLocationLabel.numberOfLines = 0
        containerView.addSubview(subLocationLabel)
        
        // 约束
        containerView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.bottom.equalToSuperview().offset(-8)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.left.equalToSuperview().offset(20)
            make.right.equalTo(thumbnailImageView.snp.left).offset(-12)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(4)
            make.left.equalToSuperview().offset(20)
            make.right.equalTo(thumbnailImageView.snp.left).offset(-12)
        }
        
        thumbnailImageView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.width.height.equalTo(60)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.top.equalTo(subtitleLabel.snp.bottom).offset(20)
            make.left.equalToSuperview().offset(20)
            make.width.equalTo(50)
        }
        
        timeValueLabel.snp.makeConstraints { make in
            make.centerY.equalTo(timeLabel)
            make.left.equalTo(timeLabel.snp.right).offset(12)
            make.right.equalToSuperview().offset(-20)
        }
        
        locationLabel.snp.makeConstraints { make in
            make.top.equalTo(timeLabel.snp.bottom).offset(16)
            make.left.equalToSuperview().offset(20)
            make.width.equalTo(50)
        }
        
        locationValueLabel.snp.makeConstraints { make in
            make.top.equalTo(locationLabel)
            make.left.equalTo(locationLabel.snp.right).offset(12)
            make.right.equalToSuperview().offset(-20)
        }
        
        subLocationLabel.snp.makeConstraints { make in
            make.top.equalTo(locationValueLabel.snp.bottom).offset(8)
            make.left.equalTo(locationValueLabel)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(-20)
        }
    }
    
    func configure(with event: CheckInEvent) {
        titleLabel.text = event.title
        subtitleLabel.text = event.subtitle
        timeValueLabel.text = event.date
        locationValueLabel.text = event.location
        subLocationLabel.text = event.subLocation
        
        if let imageName = event.thumbnailImage, let image = UIImage(named: imageName) {
            thumbnailImageView.image = image
        }
    }
}
