//
//  YHSignPrizeCellTableViewCell.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSignPrizeCell: UITableViewCell {
    static let cellReuseIdentifier = "YHSignPrizeCell"
    
    private let containerView = UIView()
    private let greetingLabel = UILabel()
    private let instructionLabel = UILabel()
    private let prizeImageView = UIImageView()
    private let overlayButton = UIButton()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        backgroundColor = .clear
        selectionStyle = .none
        
        containerView.backgroundColor = UIColor(white: 0.98, alpha: 1)
        containerView.layer.cornerRadius = 12
        contentView.addSubview(containerView)
        
        greetingLabel.font = .systemFont(ofSize: 20, weight: .medium)
        greetingLabel.textColor = .black
        containerView.addSubview(greetingLabel)
        
        instructionLabel.font = .systemFont(ofSize: 14)
        instructionLabel.textColor = .gray
        containerView.addSubview(instructionLabel)
        
        prizeImageView.contentMode = .scaleAspectFill
        prizeImageView.clipsToBounds = true
        prizeImageView.layer.cornerRadius = 8
        prizeImageView.backgroundColor = .lightGray
        containerView.addSubview(prizeImageView)
        
        overlayButton.setTitle("一步了解", for: .normal)
        overlayButton.setTitleColor(.white, for: .normal)
        overlayButton.titleLabel?.font = .systemFont(ofSize: 14)
        overlayButton.layer.cornerRadius = 16
        overlayButton.layer.borderWidth = 1
        overlayButton.layer.borderColor = UIColor.white.cgColor
        prizeImageView.addSubview(overlayButton)
        
        containerView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.bottom.equalToSuperview().offset(-8)
        }
        
        greetingLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
        }
        
        instructionLabel.snp.makeConstraints { make in
            make.top.equalTo(greetingLabel.snp.bottom).offset(8)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
        }
        
        prizeImageView.snp.makeConstraints { make in
            make.top.equalTo(instructionLabel.snp.bottom).offset(16)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(-20)
            make.height.equalTo(200)
        }
        
        overlayButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
            make.width.equalTo(100)
            make.height.equalTo(32)
        }
    }
    
    func configure(with prize: Prize) {
        greetingLabel.text = prize.greeting
        instructionLabel.text = prize.instruction
        if let image = UIImage(named: prize.image) {
            prizeImageView.image = image
        }
    }
}
