//
//  YHSignSuccessHeaderView.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSignSuccessHeaderView: UIView {
    
    private let checkIconView = UIImageView()
    private let titleLabel = UILabel()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        backgroundColor = .clear
        
        checkIconView.image = UIImage(systemName: "checkmark.circle")
        checkIconView.tintColor = .black
        addSubview(checkIconView)
        
        titleLabel.text = "签到成功"
        titleLabel.font = .systemFont(ofSize: 28, weight: .semibold)
        titleLabel.textColor = .black
        addSubview(titleLabel)
        
        checkIconView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(24)
            make.left.equalToSuperview().offset(32)
            make.width.height.equalTo(36)
            make.bottom.equalToSuperview().offset(-24)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.centerY.equalTo(checkIconView)
            make.left.equalTo(checkIconView.snp.right).offset(12)
        }
    }
}
