//
//  YHResignInfoConfirmInfoListModel.swift
//  galaxy
//
//  Created by edy on 2024/10/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import  SmartCodable

class YHResignInfoConfirmInfoListModel: SmartCodable {
    
    var id: Int = 0
    var main: YHResignInfoConfirmFamilyInfoModel?
    var spouse: YHResignInfoConfirmFamilyInfoModel?
    var children: [YHResignInfoConfirmFamilyInfoModel] = []

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case main = "main"
        case spouse = "spouse"
        case children = "children"
    }
    
    required init() {
        
    }

    init(id: Int, main: YHResignInfoConfirmFamilyInfoModel, spouse: YHResignInfoConfirmFamilyInfoModel, children: [YHResignInfoConfirmFamilyInfoModel]) {
        
        self.id = id
        self.main = main
        self.spouse = spouse
        self.children = children
    }
}

class YHResignInfoConfirmFamilyInfoModel: SmartCodable {
    
    var info: YHResignInfoConfirmFamilyModel = YHResignInfoConfirmFamilyModel()
    var confirmStatus: Int = 0

    func isConfirmed() -> Bool {
        return self.confirmStatus == 2
    }
    
    enum CodingKeys: String, CodingKey {
        case info = "info"
        case confirmStatus = "confirm_status"
    }
    
    required init() {
        
    }

    init(info: YHResignInfoConfirmFamilyModel, confirmStatus: Int) {
        self.info = info
        self.confirmStatus = confirmStatus
    }
}

class YHResignConfirmIdentityModel: SmartCodable {
    
    var id: Int = 0
    var type: Int = -1
    var name: String = ""
    var number: String = ""
    var begin: String = ""
    var end: String = ""
    var deadline: String = ""
        
    required init() {
        
    }
    
    func isValidDateEnough() -> Bool {
        
        if self.end.isEmpty || self.deadline.isEmpty {
            return true
        }
        
        let format = DateFormatter()
        format.dateFormat = "yyyy-MM-dd"
        guard let endDate = format.date(from: self.end) else {
            return true
        }
        guard let deadDate = format.date(from: self.deadline) else {
            return true
        }
        return endDate.timeIntervalSince1970 >= deadDate.timeIntervalSince1970
    }

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case type = "type"
        case name = "name"
        case number = "number"
        case begin = "begin"
        case end = "end"
        case deadline = "deadline"
    }

    init(id: Int, type: Int, name: String, number: String, begin: String, end: String, deadline: String) {
        self.id = id
        self.type = type
        self.name = name
        self.number = number
        self.begin = begin
        self.end = end
        self.deadline = deadline
    }
}

// MARK: - Info
class YHResignInfoConfirmFamilyModel: SmartCodable {
    
    var id: Int = -1
    var name: String = ""
    var nameHistory: String = ""
    var familyName: String = ""
    var familyNameHistory: String = ""
    var givenName: String = ""
    var givenNameHistory: String = ""
    var married: String = ""
    var marriedHistory: String = ""
    var nationalityType: Int = -1
    var nationalityTypeHistory: Int = -1
    var nationality: String = ""
    var nationalityHistory: String = ""
    var hkIdentityid: String = ""
    var hkIdentityidHistory: String = ""
    var identity: YHResignConfirmIdentityModel?
    var occupationName: String = ""
    var occupationNameHistory: String = ""
    var hkAddress: String = ""
    var hkAddressHistory: String = ""
    
    // 自定义属性
    var relation: Int = YHFamilyMemberRelationType.none.rawValue
    // 是否检测编辑字段
    var isNeedCheck: Bool = false
    
    required init() {
        
    }
    
    func getMarriageState() -> String {
        return self.getMarriageStatus(self.married)
    }
    
    func getHistoryMarriageState() -> String {
        return self.getMarriageStatus(self.marriedHistory)
    }
    
    func getMarriageStatus(_ marrage: String) -> String {
        let arr = YHSheetPickerView.dataSource[.marriage1]!
        for item in arr {
            if item.index == Int(marrage) {
                return item.title
            }
        }
        return ""
    }
    
    func getRelation() -> String {
        if relation == YHFamilyMemberRelationType.mainApplicant.rawValue {
            return "主申人"
            
        } else if relation == YHFamilyMemberRelationType.spouse.rawValue {
            return "配偶"
            
        } else if relation == YHFamilyMemberRelationType.child.rawValue {
            return "子女"
        }
        return ""
    }

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case name = "name"
        case nameHistory = "name_history"
        case familyName = "family_name"
        case familyNameHistory = "family_name_history"
        case givenName = "given_name"
        case givenNameHistory = "given_name_history"
        case married = "married"
        case marriedHistory = "married_history"
        case nationalityType = "nationality_type"
        case nationalityTypeHistory = "nationality_type_history"
        case nationality = "nationality"
        case nationalityHistory = "nationality_history"
        case hkIdentityid = "hk_identity_id"
        case hkIdentityidHistory = "hk_identity_id_history"
        case identity = "identity"
        case occupationName = "occupation_name"
        case occupationNameHistory = "occupation_name_history"
        case hkAddress = "hk_address"
        case hkAddressHistory = "hk_address_history"
    }

    init(id: Int, name: String, nameHistory: String, familyName: String, familyNameHistory: String, givenName: String, givenNameHistory: String, married: String, marriedHistory: String, nationalityType: Int, nationalityTypeHistory: Int, nationality: String, nationalityHistory: String, hkIdentityid: String, hkIdentityidHistory: String, identity: YHResignConfirmIdentityModel, occupationName: String, occupationNameHistory: String, hkAddress: String, hkAddressHistory: String) {
        
        self.id = id
        self.name = name
        self.nameHistory = nameHistory
        self.familyName = familyName
        self.familyNameHistory = familyNameHistory
        self.givenName = givenName
        self.givenNameHistory = givenNameHistory
        self.married = married
        self.marriedHistory = marriedHistory
        self.nationalityType = nationalityType
        self.nationalityTypeHistory = nationalityTypeHistory
        self.nationality = nationality
        self.nationalityHistory = nationalityHistory
        self.hkIdentityid = hkIdentityid
        self.hkIdentityidHistory = hkIdentityidHistory
        self.identity = identity
        self.occupationName = occupationName
        self.occupationNameHistory = occupationNameHistory
        self.hkAddress = hkAddress
        self.hkAddressHistory = hkAddressHistory
    }
}
