//
//  YHSelectCountryViewController.swift
//  galaxy
//
//  Created by EDY on 2024/1/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSelectCountryViewController: YHBaseViewController {
    public var backLocationStringController: ((String) -> Void)?
    var searchView: UITextField!
    var flagLabel: UILabel!
    var tableView: UITableView!
    var hotDataSource = ["中国-China", "中国香港-Hong Kong", "中国澳门-Macau", "中国台湾-Taiwan", "新加坡-Singapore", "澳大利亚-Australia", "美国-United States"]
    var searchDataSource: [YHCountryMessage]?
    var viewModel: YHSelectCountryViewModel?
    var typeView: YHCountryHotView!

    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "国家/地区"
        viewModel = YHSelectCountryViewModel()
        setView()
        getData()
    }
    
    func getData() {
        tableView.reloadData()
        
    }
    
    func setView() {
        view.backgroundColor = .white
        searchView = {
            let searchBar = UITextField()
            searchBar.font = .PFSC_R(ofSize: 14)
            searchBar.placeholder = "搜索国家/地区"
            searchBar.backgroundColor = UIColor.contentBkgColor
            searchBar.keyboardType = .default
            searchBar.delegate = self
            searchBar.leftView = UIView(frame: CGRect(x: 0, y: 0, width: 16, height: 42))
            searchBar.leftViewMode = .always
            return searchBar
        }()
        view.addSubview(searchView)
        searchView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 16)
            make.height.equalTo(42)
            make.left.equalTo(16)
            make.right.equalTo(-16)
        }
        
        tableView = {
            let tableView = UITableView(frame: .zero, style: .plain)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHCountryTableViewCell.self)
            tableView.isHidden = true
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 78)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 64)
            make.left.right.equalTo(view)
        }
        
        flagLabel = {
            let label = UILabel()
            label.text = "热门国家/地区"
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_R(ofSize: 14)
            return label
        }()
        view.addSubview(flagLabel)
        flagLabel.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 78)
            make.left.equalTo(21)
            make.height.equalTo(20)
        }
        
        typeView = {
            let view = YHCountryHotView()
            view.dataSource = self.hotDataSource
            view.isHidden = false
            view.hotBlock = {[weak self] string in
                guard let self = self else { return }
                view.isHidden = true
                if let backLocationStringController = backLocationStringController {
                    backLocationStringController(string)
                    self.navigationController?.popViewController()
                }
            }
            return view
        }()
        view.addSubview(typeView)
        typeView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 114)
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
        }
    }
}

extension YHSelectCountryViewController: UITextFieldDelegate {
    func textFieldDidChangeSelection(_ textField: UITextField) {
        if textField.text == "" {
            tableView.isHidden = true
            flagLabel.isHidden = false
            typeView.isHidden = false
        } else {
            viewModel?.requestCountry(textField.text ?? "") { [weak self] success, _ in
                guard let self = self else { return }
                self.searchDataSource = success as? [YHCountryMessage]
                self.tableView.isHidden = false
                self.flagLabel.isHidden = true
                self.typeView.isHidden = true
                self.tableView.reloadData()
            }
        }
    }
}

extension YHSelectCountryViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return searchDataSource?.count ?? 0
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHCountryTableViewCell.self)
        let cn = searchDataSource?[indexPath.row].name_cn ?? ""
        let en = searchDataSource?[indexPath.row].name_en ?? ""
        cell.titleLabel.text = cn + "-" + en
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cn = searchDataSource?[indexPath.row].name_cn ?? ""
        let en = searchDataSource?[indexPath.row].name_en ?? ""
        let text = cn + "-" + en
        if let backLocationStringController = backLocationStringController {
            backLocationStringController(text)
            self.navigationController?.popViewController()
        }
    }
}

class YHCountryTableViewCell: UITableViewCell {
    var titleLabel: UILabel!
    var messagelabel: UILabel!

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 13)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        contentView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
        }
        
        messagelabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 13)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .right
            return label
        }()
        contentView.addSubview(messagelabel)
        messagelabel.snp.makeConstraints { make in
            make.right.equalTo(-22)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
        }
    }
}
