//
//  YHGCSignatureAddTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/12/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCSignatureAddTableViewCell: UITableViewCell {
    typealias WorkExperienceBlock = (_ model: YHWorkExperienceModel) -> Void
    typealias CompanyBlock = (_ model: YHCompanyModelListModel) -> Void
    var companyBlock: CompanyBlock?
    var workExperienceBlock: WorkExperienceBlock?
    var centerView: UIView!
    var mainItemView: UIView!
    var country: String = ""
    var dataSource: YHSectionWorkExperienceModel? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        var y = 0
        for i in 0 ..< (dataSource?.models?.count ?? 0) {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            y += 1
            let data = dataSource?.models?[i]
            let isShow = data?.isShowPrompts ?? false
            let message = data?.message ?? ""
            
            var h = 51
            if data?.id == .id7 {
                h = 71
            }
            if isShow && message.count == 0 {
                h += 20
            }
            let itemView = YHWorkExperienceItemView()
            itemView.dataSource = data
            itemView.country = country
            itemView.block = {[weak self] model in
                guard let self = self else { return }
                if let block = self.workExperienceBlock {
                    block(model)
                }
            }
            itemView.companyBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.companyBlock {
                    block(model)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(h)
                make.right.equalTo(-18)
            }
            y += h
        }
        
    }
}
