//
//  YHGCBasicInfoFillViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCBasicInfoFillViewModel: YHBaseViewModel {
    // UI层需要的数据源
    var arrBasicInfoSessionDataForEdit: [YHBasicInfoSessionModel] = []

    // 从网络请求的数据源
    var dataModelForBasicInfo: YHGCBasicInfoFillModel? {
        didSet {
            assembleBasicInfoData()
        }
    }
}

extension YHGCBasicInfoFillViewModel {
    private func createOrgBasiceInfoData() {
        var arrData: [YHBasicInfoSessionModel] = []
        do {
            // 主申请人
            let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: "", info: "")
            let model2 = YHBasicInfoCellModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: "", info: "")
            let arr = [model1, model2]

            let sessionModel = YHBasicInfoSessionModel(sessionTitle: "主申请人", arrQuestionItem: arr)
            arrData.append(sessionModel)
        }

        do {
            // 配偶
            let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: "", info: "")
            let model2 = YHBasicInfoCellModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: "", info: "")
            let arr = [model1, model2]

            let sessionModel = YHBasicInfoSessionModel(sessionTitle: "配偶", arrQuestionItem: arr)
            arrData.append(sessionModel)
        }

        do {
            // 子女 - xxx
            let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: "", info: "")
            let model2 = YHBasicInfoCellModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: "", info: "")
            let arr = [model1, model2]

            let sessionModel = YHBasicInfoSessionModel(sessionTitle: "子女 - xxx", arrQuestionItem: arr)
            arrData.append(sessionModel)
        }
        arrBasicInfoSessionDataForEdit = arrData
    }

    // 根据网络数据 组装数据
    private func assembleBasicInfoData() {
        guard let dataModelForBasicInfo = dataModelForBasicInfo else {
            createOrgBasiceInfoData()
            return
        }

        var arrData: [YHBasicInfoSessionModel] = []
        do {
            // 主申请人
            if let model = dataModelForBasicInfo.applicant {
                let answer1 = getAnswerString(model.deny) // model.deny == 0 ? "N" : "Y"
                let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: answer1, info: model.denyContent)

                let answer2 = getAnswerString(model.crime) // model.crime == 0 ? "N" : "Y"
                let model2 = YHBasicInfoCellModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: answer2, info: model.crimeContent)
                let arr = [model1, model2]
                let sessionModel = YHBasicInfoSessionModel(sessionTitle: "主申请人", arrQuestionItem: arr)
                arrData.append(sessionModel)
            }
        }

        do {
            // 配偶
            if let spouse = dataModelForBasicInfo.spouse {
                let answer1 = getAnswerString(spouse.deny) // spouse.deny == 0 ? "N" : "Y"
                let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: answer1, info: spouse.denyContent)

                let answer2 = getAnswerString(spouse.crime) // spouse.crime == 0 ? "N" : "Y"
                let model2 = YHBasicInfoCellModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: answer2, info: spouse.crimeContent)
                let arr = [model1, model2]

                let sessionModel = YHBasicInfoSessionModel(sessionTitle: "配偶", arrQuestionItem: arr)
                arrData.append(sessionModel)
            }
        }

        do {
            // 子女 - xxx
            if let arrChild = dataModelForBasicInfo.child {
                for item in arrChild {
                    let answer1 = getAnswerString(item.deny) // item.deny == 0 ? "N" : "Y"
                    let model1 = YHBasicInfoCellModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: answer1, info: item.denyContent)
                    
                    let answer2 = getAnswerString(item.crime) // item.crime == 0 ? "N" : "Y"
                    let model2 = YHBasicInfoCellModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: answer2, info: item.crimeContent)
                    let arr = [model1, model2]

                    let title = "子女" + "-" + item.name
                    let sessionModel = YHBasicInfoSessionModel(sessionTitle: title, arrQuestionItem: arr)
                    sessionModel.gcModel = item
                    arrData.append(sessionModel)
                }
            }
        }
        arrBasicInfoSessionDataForEdit = arrData
    }
    
    private func getAnswerString(_ answer: Int) -> String {
        switch answer {
        case 0:
            return "N"
        case 1:
            return "Y"
        case 2:
            return ""
        default:
            return ""
        }
    }
}

extension YHGCBasicInfoFillViewModel {
    // 获取基本资料信息
    func getBasicInfo(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.GCBasics.basicInfoApi

        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")

            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHGCBasicInfoFillModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }

                self.dataModelForBasicInfo = resultModel
                // 根据返回值 组装 真实的数据
                callBackBlock(true, nil)

            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }

    // 保存基本资料信息
    func saveBasicInfo(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.GCBasics.updateBasicInfoApi
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
