//
//  YHSurveyViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2025/3/28.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSurveyViewModel: YHBaseViewModel {
    var surveyContainerModel: YHSurveyContainerModel?

    var responseModel: YHSurveyResponseModel?

    var planState: YHSurveyRenewalPlanState?
}

extension YHSurveyViewModel {
    /*
     问卷内容
     */
    func getSurveyContent(callback: @escaping (_ contentModel: YHSurveyContainerModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Survey.surveyContent
        _ = YHNetRequest.getRequest(url: strUrl, params: [:]) { [weak self] json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")

            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHSurveyContainerModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                self?.surveyContainerModel = resultModel
                callback(resultModel, nil)

            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }

        } failBlock: { err in
            callback(nil, err)
        }
    }

    /*
     问卷提交
     */
    func submitSurveyAnswer(requestModel: YHSurveySubmitRequestModel, callBackBlock: @escaping (_ responseModel: YHSurveyResponseModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Survey.submitSurveyAnswer
        let answerDetails: [[String: Any]] = requestModel.answerDetails.compactMap({ item in
            let optionExtra: [[String: Any]] = item.optionExtra.compactMap { extra in
                ["option_id": extra.optionId, "extra": extra.extra, "title": extra.title, "option_key": extra.optionKey]
            }
            return ["question_id": item.questionId, "question_type": item.questionType, "text": "", "title": item.title, "question_key": item.questionKey, "option_extra": optionExtra, "file_list": []]
        })
        let params: [String: Any] = ["survey_id": requestModel.surveyId, "answer_details": answerDetails]
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHSurveyResponseModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(nil, err)
                    return
                }
                self?.responseModel = resultModel
                callBackBlock(resultModel, nil)

            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(nil, err)
            }
        } failBlock: { err in
            callBackBlock(nil, err)
        }
    }

    /*
     问卷是否生成方案
     */
    func getRenewalPlanState(callback: @escaping (_ planState: YHSurveyRenewalPlanState?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Survey.getRenewalPlanState
        _ = YHNetRequest.getRequest(url: strUrl, params: [:]) { [weak self] json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")

            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHSurveyRenewalPlanState.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                self?.planState = resultModel
                callback(resultModel, nil)

            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }

        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    /*
     问卷首页是否生成方案
     */
    func getRenewalPlanGenerated(callback: @escaping (_ planState: YHSurveyRenewalPlanState?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Survey.getRenewalPlanGenerated
        _ = YHNetRequest.getRequest(url: strUrl, params: [:]) { [weak self] json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")

            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHSurveyRenewalPlanState.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                self?.planState = resultModel
                callback(resultModel, nil)

            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }

        } failBlock: { err in
            callback(nil, err)
        }
    }
}
