//
//  YHGradientView.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Lottie

class YHGradientView: UIView {
    private lazy var liveAnimationView: LottieAnimationView = {
        let view = LottieAnimationView(name: "live")
        view.backgroundColor = UIColor.clear
        view.loopMode = .loop
        return view
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .white
        label.text = "直播中"
        label.font = .PFSC_R(ofSize: 11)
        return label
    }()
    
    override class var layerClass: AnyClass {
        return CAGradientLayer.self
    }
    
    init() {
        super.init(frame: .zero)
        setupGradient()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setupGradient()
    }
    
    private func setupGradient() {
        guard let gradientLayer = layer as? CAGradientLayer else {
            return
        }
        gradientLayer.colors = [
            (UIColor(hexString: "#AFCEFF") ?? UIColor()).cgColor,
            (UIColor(hexString: "#0046B4") ?? UIColor()).cgColor,
            (UIColor(hexString: "#0046B4") ?? UIColor()).cgColor,
            (UIColor(hexString: "#AFCEFF") ?? UIColor()).cgColor
        ]
        gradientLayer.startPoint = CGPoint(x: 0, y: 0.5)  // 上边中点
        gradientLayer.endPoint = CGPoint(x: 1, y: 0.5)    // 下边中点
        addSubview(liveAnimationView)
        addSubview(infoTitleLabel)
        liveAnimationView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(8)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(18)
        }
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(liveAnimationView.snp.right)
            make.centerY.equalToSuperview()
            make.right.lessThanOrEqualToSuperview().offset(-12)
        }
    }
    
    func play(_ needPlay: Bool) {
        if needPlay {
            liveAnimationView.play()
        } else {
            liveAnimationView.stop()
        }
    }
}
