//
//  YHCircleViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/24.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

// MARK: - ViewModel
class YHCircleViewModel {
    
    var arrCircleData: [YHHomeListModel]? = []
    var hasMoreForCircle = true
    var preloadItemIndex = 10
    private var currentPage = 1
    
    func getCircleList(firstFlag: Bool, completion: @escaping (Bool, String?) -> Void) {
        if firstFlag {
            currentPage = 1
            arrCircleData?.removeAll()
        }
        
        DispatchQueue.main.asyncAfter(deadline: .now() + 1.0) {
            let mockData = self.generateMockCircleData(page: self.currentPage)
            
            if firstFlag {
                self.arrCircleData = mockData
            } else {
                self.arrCircleData?.append(contentsOf: mockData)
            }
            
            self.arrCircleData?.forEach { $0.calHeightParam() }
            
            self.currentPage += 1
            self.hasMoreForCircle = self.currentPage <= 5
            
            completion(true, nil)
        }
    }
    
    func toggleLike(postId: Int, completion: @escaping (Bool, String?) -> Void) {
        DispatchQueue.main.asyncAfter(deadline: .now() + 0.5) {
            if let index = self.arrCircleData?.firstIndex(where: { $0.id == postId }) {
                let item = self.arrCircleData![index]
                item.is_like.toggle()
                item.like_count += item.is_like ? 1 : -1
                completion(true, nil)
            } else {
                completion(false, "动态不存在")
            }
        }
    }
    
    private func generateMockCircleData(page: Int) -> [YHHomeListModel] {
        let contents = [
            "今天天气真不错，出来走走心情都变好了！",
            "分享一下最近读的这本书，非常推荐给大家",
            "周末和朋友们一起聚餐，开心～",
            "工作虽然忙碌，但还是要保持积极的心态",
            "旅行中遇到的美景，忍不住分享给大家",
            "学习新技能的路上，每天都有新收获",
            "美食当前，减肥明天再说吧"
        ]
        
        let names = ["张小明", "李小红", "王小强", "赵小美", "孙小华", "周小军", "吴小芳"]
        let locations = ["北京·朝阳区", "上海·浦东新区", "深圳·南山区", "杭州·西湖区", "成都·锦江区", ""]
        
        return (0..<8).map { i in
            let model = YHHomeListModel()
            model.id = i
            model.img_url = "https://picsum.photos/60/60?random=\(i)"
            model.content = contents[i % contents.count]
            model.like_count = Int.random(in: 0...99)
            model.is_like = Bool.random()
            
            return model
        }
    }
}
