//
//  YHVisaPaymentTipsCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaPaymentTipsCell: UITableViewCell {

    static let cellReuseIdentifier = "YHVisaPaymentTipsCell"
    static let cellH: CGFloat = 236.0 * (KScreenWidth - 16 * 2) / 343.0

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        return view
    }()
    
    lazy var bgImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "visalPay_tips"))
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(bgImgView)
        
        whiteContentView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        bgImgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}
