//
//  YHHKImmigrationEditRecordModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

class YHHKImmigrationEditRecordModel {
    var valueChanged: ((Bool) -> Void)?
    var id: Int?
    var order_id: Int = 0
    var users: [YHHKRecordsUserItem] = [] {
        didSet {
            valueChanged?(isSubmittable)
        }
    }
    var start_date: String = "" {
        didSet {
            valueChanged?(isSubmittable)
        }
    }
    var end_date: String = "" {
        didSet {
            valueChanged?(isSubmittable)
        }
    }
    var remark: String = ""
    
    var isSubmittable: Bool {
        let basicInfoOk = order_id > 0 && users.count > 0 && start_date.count > 0 && end_date.count > 0
        var ret: Bool = basicInfoOk
        if let id = id {
            ret = ret && id > 0
        }
        return ret
    }
    
    func getParameters() -> [String: Any] {
        var parameters: [String: Any] = [:]
        if let id = id {
            parameters["id"] = id
        }
        parameters["order_id"] = order_id
        parameters["start_date"] = start_date
        parameters["end_date"] = end_date
        parameters["remark"] = remark
        var userDicArr: [[String: Any]] = []
        users.forEach { item in
            var dict = [String: Any]()
            dict["user_type"] = item.user_type
            dict["user_id"] = item.user_id
            userDicArr.append(dict)
        }
        parameters["users"] = userDicArr
        return parameters
    }
}
