//
//  YHResignAppointViewModel.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHResingTimeModel: SmartCodable {
    var stay_deadline: String = ""
    var stay_deadline_start: String = ""
    
    required init() {
        
    }
}

class YHResignAppointViewModel: NSObject {

    // 赴港人员列表
    var appointUsers: [YHResignAppointMember] = []
    // 预约列表预约
    var scheduleInfoList: YHResignScheduleListModel = YHResignScheduleListModel()
    
    // 获取续签提交时间
    func getResignSubmitTime(renewalId: Int, userIds: [Int], callBack: @escaping (_ result: YHResingTimeModel?) -> Void) {
        
        let params: [String: Any] = ["renewal_id": renewalId,
                                     "user_id": userIds]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.submitTime
        _ = YHNetRequest.postRequest(url: strUrl, params: params) {[weak self] json, _ in
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResingTimeModel.deserialize(from: dic) else {
//                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBack(nil)
                    return
                }
                callBack(resultModel)
                
            } else {
//                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBack(nil)
            }
        } failBlock: { _ in
            callBack(nil)
        }
        
    }
    
    // 赴港人员列表
    func getResignAppointUserlist(renewalId: Int, callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params = ["renewal_id": renewalId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.appointUserList
        _ = YHNetRequest.getRequest(url: strUrl, params: params) {
            [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [Any], let resultModel = [YHResignAppointMember].deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.appointUsers = []
                    callBack(false, err)
                    return
                }
                self.appointUsers = resultModel
                callBack(true, nil)
                
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                self.appointUsers = []
                callBack(false, error)
            }
            
        } failBlock: { err in
            self.appointUsers = []
            callBack(false, err)
        }
    }
    
    // 预约列表预约
    func getScheduleInfoList(renewalId: Int, callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params = ["renewal_id": renewalId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.appointInfoList
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignScheduleListModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBack(false, err)
                    return
                }
                self.scheduleInfoList = resultModel
                callBack(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                self.scheduleInfoList = YHResignScheduleListModel()
                callBack(false, err)
            }
        } failBlock: { err in
            self.scheduleInfoList = YHResignScheduleListModel()
            callBack(false, err)
        }
    }
    
    // 提交预约
    func submitAppointInfo(params: [String: Any], callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.submitAppoint
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBack(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBack(false, error)
            }
        } failBlock: { err in
            callBack(false, err)
        }
    }
    
    // 点击确认在港
    func submitConfirmInHK(id: Int, is_edit: Int, callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id,
                                     "is_edit": is_edit]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.confirmInHK
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBack(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBack(false, error)
            }
        } failBlock: { err in
            callBack(false, err)
        }
    }
}
