//
//  YHIncomeItemOccupyingCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeItemOccupyingCell: YHResignDocumentCell {
    
    static let cellReuseIdentifier = "YHIncomeItemOccupyingCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_B(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "收入信息1"
        return label
    }()
    
    private lazy var rightLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = UIColor(hexString: "#8993A2")
        label.text = "待填写"
        return label
    }()
    
    private lazy var rightArrowIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imageView
    }()

    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, rightText: String = "待填写", showBottomLine: Bool = false) {
        infoTitleLabel.text = title
        rightLabel.text = rightText
        bottomLineView.isHidden = !showBottomLine
    }
}

extension YHIncomeItemOccupyingCell {

    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(rightArrowIcon)
        subContainerView.addSubview(rightLabel)
        subContainerView.addSubview(bottomLineView)
        
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightArrowIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        rightLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
        }
        
        rightArrowIcon.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-18)
            make.width.height.equalTo(20)
            make.centerY.equalTo(infoTitleLabel)
        }
        
        rightLabel.snp.makeConstraints { make in
            make.right.equalTo(rightArrowIcon.snp.left).offset(-2)
            make.centerY.equalTo(infoTitleLabel)
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(10)
        }

        bottomLineView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(16)
        }
    }
}
