//
//  YHIncomeRecordSummaryCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeRecordSummaryCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHIncomeRecordSummaryCell"
    var rightButtonClickEvent: (() -> Void)?

    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "主申请人收入记录"
        return label
    }()

    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = UIColor(hexString: "#8993A2")
        label.text = "(仅申报近12个月应纳税收入总额)"
        return label
    }()

    private lazy var rightButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitle("编辑", for: .normal)
        button.setTitle("取消编辑", for: .selected)
        button.setTitleColor(.brandMainColor, for: .normal)
        button.titleLabel?.font = .PFSC_R(ofSize: 14)
        button.addTarget(self, action: #selector(rightButtonDidClick(_:)), for: .touchUpInside)
        return button
    }()

    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    func setupCellInfo(_ isEditing: Bool, _ isEditEnable: Bool, showRightButton: Bool, showBottomLine: Bool = true) {
        bottomLineView.isHidden = !showBottomLine
        rightButton.isHidden = !showRightButton
        rightButton.isEnabled = isEditEnable
        updateRightButtonState(isEditing)
    }
}

extension YHIncomeRecordSummaryCell {
    @objc private func rightButtonDidClick(_ sender: UIButton) {
        rightButtonClickEvent?()
    }
    
    private func updateRightButtonState(_ isEditing: Bool) {
        rightButton.isSelected = isEditing
        if isEditing {
            rightButton.snp.remakeConstraints { make in
                make.right.equalToSuperview().offset(-18)
                make.top.equalToSuperview().offset(16)
                make.width.equalTo(56)
                make.height.equalTo(24)
            }
        } else {
            rightButton.snp.remakeConstraints { make in
                make.right.equalToSuperview().offset(-18)
                make.top.equalToSuperview().offset(16)
                make.width.height.equalTo(28)
            }
        }
    }

    private func setupUI() {
        updateCellCorner(.top)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(rightButton)
        subContainerView.addSubview(bottomLineView)
        rightButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-18)
            make.top.equalToSuperview().offset(16)
            make.width.height.equalTo(24)
        }

        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.right.lessThanOrEqualTo(rightButton.snp.left).offset(-10)
        }

        infoDetailLabel.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel.snp.left)
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(2)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }

        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.top.equalTo(infoDetailLabel.snp.bottom).offset(16)
        }
    }
}
