//
//  YHCompanyViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/2/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCompanyViewModel: YHBaseViewModel {
    override init() {
        super.init()
    }
    
    func requestCompany(_ key: String, callBackBlock: @escaping (_ success: [YHCompanyModelListModel]?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.company
        let params = ["company_name": key, "page_size": 20, "current_page": 1] as [String: Any]
        
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHCompanyModel.deserialize(from: dic) else {
                    callBackBlock([], nil)
                    return
                }
                callBackBlock(result.list, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock([], error)
            }
        } failBlock: { err in
            callBackBlock([], err)
        }
    }
}
