//
//  YHGCIncomeType.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation
// 高A使用 收入类型 1 工资薪金所得及全年一次性奖金; 2 上市公司股票期权或股权收入; 3 持股公司分红收入; 4 个体工商户/合伙企业/独资企业经营所得收入; 5 股权转让收入; 6 内地公司收入(持股50%及以上); 7 香港公司收入(持股50%及以上); 8 其他境外公司收入(持股50%及以上); 10 澳门公司收入(持股50%及以上)

enum YHGCIncomeType: Int, CaseIterable {
    case salaryIncomeAndBonus = 1
    case stockOrEquityIncome = 2
    case dividendIncome = 3
    case businessIncome = 4
    case equityTransferIncome = 5
    case incomeOfMainland = 6
    case incomeOfHKCompanies = 7
    case incomeOfOtherOverseasCompanies = 8
    case incomeOfMacauCompanies = 10
    
    func nameString() -> String {
        switch self {
        case .incomeOfMainland:
            return "内地公司收入(持股50%及以上)"
        case .incomeOfHKCompanies:
            return "香港公司收入(持股50%及以上)"
        case .incomeOfMacauCompanies:
            return "澳门公司收入(持股50%及以上)"
        case .stockOrEquityIncome:
            return "上市公司股票期权或股权收入"
        case .salaryIncomeAndBonus:
            return "工资薪金所得及全年一次性奖金"
        case .dividendIncome:
            return "持股公司分红收入"
        case .equityTransferIncome:
            return "股权转让收入"
        case .businessIncome:
            return "个体工商户/合伙企业/独资企业经营所得收入"
        case .incomeOfOtherOverseasCompanies:
            return "其他境外公司收入(持股50%及以上)"
        }
    }
}
