//
//  YHAIGreetCollectionReusableView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Lottie

class YHAIGreetCollectionReusableView: UICollectionReusableView {
        
    static let reuseIdentifier: String = "YHAIGreetCollectionReusableView"
    
    let horizonalGap = 16.0
    
    lazy var iconImgView: LottieAnimationView! = {
        let lottieView = LottieAnimationView(name: "gangxiaobao_logo")
        lottieView.loopMode = .loop
        lottieView.contentMode = .scaleAspectFit
        lottieView.play()
        return lottieView
    }()
    
    lazy var quoteImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: "ai_product_list_head_quate"))
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont(name: "AlibabaPuHuiTi_3_95_ExtraBold", size: 30)
        lable.text = "Hi, 早上好!"
        return lable
    }()
    
    lazy var subtitleLabel: UILabel = {
        let lable = UILabel()
        lable.textAlignment = .left
        lable.numberOfLines = 0
        lable.lineBreakMode = .byCharWrapping
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 4.0
        let attributedText = NSAttributedString(
            string: "首个聚焦香港的AI智能体，\"港小宝\" 来啦~深度解析身份规划，解锁香港生活未来密码！共赴新港生活奇妙之旅吧！",
            attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle,
                         NSAttributedString.Key.foregroundColor: UIColor.mainTextColor(alpha: 0.6),
                         NSAttributedString.Key.font: UIFont.PFSC_R(ofSize: 14)]
        )
        lable.attributedText = attributedText
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func updateGreetingText() {
        titleLabel.text = greetingBasedOnTime()
    }
    
    func createUI() {
        
        self.addSubview(iconImgView)
        self.addSubview(titleLabel)
        self.addSubview(subtitleLabel)
        self.addSubview(quoteImgView)
     
        iconImgView.snp.makeConstraints { make in
            make.right.equalTo(-20+horizonalGap)
            make.top.equalTo(4)
            make.width.equalTo(120)
            make.height.equalTo(94)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(24-horizonalGap)
            make.bottom.equalTo(iconImgView.snp.bottom).offset(-15)
            make.height.equalTo(42)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.left.equalTo(24-horizonalGap)
            make.right.equalTo(-24+horizonalGap)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
        }
        
        quoteImgView.snp.makeConstraints { make in
            make.width.equalTo(27)
            make.height.equalTo(18)
            make.right.equalTo(subtitleLabel)
            make.bottom.equalTo(subtitleLabel.snp.bottom).offset(10)
        }
    }
    
    func greetingBasedOnTime() -> String {
        
        let currentDate = Date()
        let calendar = Calendar.current
        let hour = calendar.component(.hour, from: currentDate)
        let minute = calendar.component(.minute, from: currentDate)
        
        var result = "Hi，"

        switch (hour, minute) {
        case (5..<8, _):
            result += "早上好"
        case (8, 0..<30):
            result += "早上好"
        case (8, 30..<60):
            result +=  "上午好"
        case (8..<11, _):
            result +=  "上午好"
        case (11..<14, _):
            result +=  "中午好"
        case (14..<18, _):
            result +=  "下午好"
        case (18..<24, _):
            result +=  "晚上好"
        case (0..<5, _):
            result +=  "晚上好"
        default:
            result +=  "晚上好" // 默认情况
        }
        result += "!"
        return result
    }
    
}
