//
//  YHOfficalLetterListModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHOfficalLetterModel: SmartCodable {
    var id: Int = -1// 申请记录的唯一标识符
    var applicant: String = ""// 申请人的姓名
    var approval_date: String = ""// 申请人姓名
    var applicant_approval_date: String = ""// 申请的日期和时间
    var archivist_id: Int = -1// 来自相关记录的数据ID
    var data_from_type: Int = -1 // 数据来源的类型
    var deleted_at: String = ""// 申请记录被删除的时间（可选）
    var e_visa_cn: String = ""// 申请人姓名
    var email_received_at: String = "" // 邮件接收时间
    var file_no: String = ""// 文件编号
    var file_num: String = ""// 文件号（可能与file_no重复，用于不同场景）
    var file_type: Int = -1 // 文件类型
    var file_url_transformed: String = ""// 转换后的文件URL
    var from_order_id: Int = -1 // 来源订单ID
    var from_relation: Int = -1// 与申请人关系的代码
    var from_relation_cn: String = ""// 与申请人关系的中文描述
    var handler: String = ""// 处理申请的人员
    var is_check: Int = -1// 是否进行了检查
    var name: String = ""// 申请人的姓名
    var pay_deadline: String = ""// 支付截止日期
    var read_status: Int = -1 // 阅读状态（例如：未读，已读）
    var remark: String = ""// 备注信息
    var remark_archivist: [String] = []// 备注信息，可包含多个档案管理员的备注
    var result: Int = -1// 申请结果代码
    var result_at: String = ""// 申请结果的时间
    var result_cn: String = ""// 申请结果的中文描述
    var type: String = ""// 申请的类型（例如：旅游，商务）
    var updated_at: String = "" // 申请记录最后更新的时间
    var url: String = ""// 文件的URL
    
    required init() {
    }
}

class YHOfficalLetterListModel: SmartCodable {
    var order_id: Int = -1// 订单id
    var applicant_id: Int = -1// 申请人id
    var applicant_name: String = ""// 申请人姓名
    var applicant_approval_date: String = ""// 申请人通过时间
    var applicant_sex: Int = -1// 申请人性别
    var days: Int = -1 // 天数
    
    var list: [YHOfficalLetterModel] = []
    required init() {
    }
}
