//
//  YHFileItemView.swift
//  galaxy
//
//  Created by EDY on 2024/3/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHDocumentFileItemView: UIView {
    typealias ItemBlock = (YHMyFileMethodType, Int) -> Void
    var itemBlock: ItemBlock?
    var fileImageView: UIImageView!
    var fileNameLabel: UILabel!
    var deleteButton: UIButton!
    var centerButton: UIButton!
    var index: Int = 0
    var docType: Int = 0
    var type: Int = 0
    var dataSource: String? {
        didSet {
            updateAllViews()
        }
    }
    
    var docDataSource: YHMySignedDocumentModel? {
        didSet {
            updateDocAllViews()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        fileImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "")
            return view
        }()
        addSubview(fileImageView)
        fileImageView.snp.makeConstraints { make in
            make.left.equalTo(6)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(31)
        }
        
        fileNameLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            label.text = "雇主的推荐信(仅签字)华为科技有限公司.doc"
            return label
        }()
        addSubview(fileNameLabel)
        fileNameLabel.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(49)
            make.top.bottom.equalToSuperview()
        }
        
        centerButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(centerClick), for: .touchUpInside)
            return button
        }()
        addSubview(centerButton)
        centerButton.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(112)
            make.right.equalTo(-50)
        }
        
        deleteButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "my_cer_btn_edit"), for: .normal)
            button.addTarget(self, action: #selector(deleteClick), for: .touchUpInside)
            return button
        }()
        addSubview(deleteButton)
        deleteButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.height.equalTo(16)
        }
        
        deleteButton.YH_clickEdgeInsets = UIEdgeInsets(top: 10, left: 10, bottom: 10, right: 10)
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
//        1-代理委托书，2-受养人声明，3-工作经验补充表，4-声明书，5-人才清单声明书，6-个人陈述书，7-推荐信，8-组织架构图
        var name = ""
        if docType == 1 {
            name = "代理委托书"
        }
        if docType == 2 {
            name = "受养人声明"
        }
        if docType == 3 {
            name = "工作经验补充表"
        }
        if docType == 4 {
            name = "声明书"
        }
        if docType == 5 {
            name = "人才清单声明书"
        }
        if docType == 6 {
            name = "个人陈述书"
        }
        if docType == 7 {
            name = "推荐信"
        }
        if docType == 8 {
            name = "组织架构图"
        }
        let suffix =  dataSource.pathExtension.lowercased()
        var iconImgName = ""
        if suffix == "jpeg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "jpg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "png" {
            iconImgName = "my_cer_type_png"
        } else if suffix == "pdf" {
            iconImgName = "my_cer_type_pdf"
        } else if suffix == "doc" || suffix == "docx" {
            iconImgName = "my_cer_type_word"
        } else if suffix == "ppt" || suffix == "pptx" {
            iconImgName = "my_cer_type_ppt"
        } else if suffix == "bmp" {
            iconImgName = "my_cer_type_bmp"
        } else if suffix == "tiff" {
            iconImgName = "my_cer_type_tiff"
        } else if suffix == "xls" || suffix == "xlsx" {
            iconImgName = "my_cer_type_excel"
        }

        fileImageView.image = UIImage(named: iconImgName)
        fileNameLabel.text = name + "\(index + 1)(已签章)"
    }
    
    func updateDocAllViews() {
        guard let docDataSource = docDataSource else { return }
        let suffix =  docDataSource.url.pathExtension.lowercased()
        var iconImgName = ""
        if suffix == "jpeg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "jpg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "png" {
            iconImgName = "my_cer_type_png"
        } else if suffix == "pdf" {
            iconImgName = "my_cer_type_pdf"
        } else if suffix == "doc" || suffix == "docx" {
            iconImgName = "my_cer_type_word"
        } else if suffix == "ppt" || suffix == "pptx" {
            iconImgName = "my_cer_type_ppt"
        } else if suffix == "bmp" {
            iconImgName = "my_cer_type_bmp"
        } else if suffix == "tiff" {
            iconImgName = "my_cer_type_tiff"
        } else if suffix == "xls" || suffix == "xlsx" {
            iconImgName = "my_cer_type_excel"
        }

        fileImageView.image = UIImage(named: iconImgName)
        fileNameLabel.text = docDataSource.name
    }
    
    @objc func centerClick() {
        if let block = itemBlock {
            block(.look, index)
        }
    }
    
    @objc func deleteClick() {
        var items = [YHCertificateEditItem(type: .preview, title: "预览"),
                     YHCertificateEditItem(type: .reupload, title: "重传"),
                     YHCertificateEditItem(type: .delete, title: "删除"),
                     YHCertificateEditItem(type: .cancel, title: "取消")]
        if type == 4 || type == 5 || type == 1004 || type == 1005 || type == 1006 || type == 1007 {
            items = [YHCertificateEditItem(type: .preview, title: "预览"),
                     YHCertificateEditItem(type: .cancel, title: "取消")]
        }
        
        YHCertificateEditSheetView.sheetView(items: items) {
            [weak self] editType in
            guard let self = self else { return }
            if editType == .reupload {
                if let block = itemBlock {
                    block(.reUpload, index)
                }
            } else if editType == .delete { // 删除
                if let block = itemBlock {
                    block(.delete, index)
                }
            } else if editType == .preview { // 预览
                if let block = itemBlock {
                    block(.look, index)
                }
            }
        }.show()
    }
}
