//
//  YHMyDocumentsDetailViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/3/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Alamofire

class YHMyDocumentsDetailViewModel: YHBaseViewModel {
    var mainModel: YHMyDocumentDetailModel?
    var urlModel: YHMyDocumentsUrlModel?
    var pageUrl: String?
    var personalUrl: String?
    
    // 赴港计划书数据
    var arrHKPlanData: [YHHKPlanDocModel] = []
    
    override init() {
        super.init()
    }
    
    func requestDocumentsDetail(_ supplementId: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["supplement_id": supplementId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.detailApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMyDocumentDetailModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.mainModel = result
                // 组装赴港计划书数据
                self.installHKPlanData()
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestDocumentsTemporaryUrl(_ supplementId: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["supplement_id": supplementId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.temporaryUrlApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMyDocumentsUrlModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.urlModel = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestDocumentSubmit(_ supplementId: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["supplement_id": supplementId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.submitApi
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 提交赴港计划书
    func submitHKPlanDocument(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.hkPlanApi
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // authority 1-读 2-写
    func requestDocumentRecord(_ supplementId: String, _ authority: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["supplement_id": supplementId,
                                      "authority": authority]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.recordApi
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePageURL(_ id: String, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.pageUrl
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                self.pageUrl = json.data?.peel as? String
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePersonalURL(callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personalUrl
        _ = YHNetRequest.postRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.personalUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePersonalWithNameAndPhoneURL(name: String, phone: String, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["user_name": name,
                                      "mobile": phone]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personalUrl
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.personalUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureLook(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.look
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                self.pageUrl = json.data?.peel as? String
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureDownload(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.download
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestFileAction(_ id: String, _ type: Int, _ newArray: [String], _ oldUrl: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id,
                                      "op_type": type,
                                      "new_url": newArray,
                                      "old_url": oldUrl]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.upload
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
//                guard let dic = json.data?.peel as? [String : Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
//                    callBackBlock(false,nil)
//                    return
//                }
//                self?.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignCallBack(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.callBack
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignConfirm(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.confirm
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func sendEmailForDocs(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.sendMail
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else {
                callBackBlock(false, nil)
                return
            }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func sendEmailForDoc(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.sendDocMail
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else {
                callBackBlock(false, nil)
                return
            }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignBack(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.signCallBack
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestCheckPersonalStatus(_ id: String) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personal
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { _, _ in
        } failBlock: { _ in
        }
    }
}

private extension YHMyDocumentsDetailViewModel {
    func installHKPlanData() {
        guard let model = self.mainModel?.prospectus else { return }
        arrHKPlanData.removeAll()
        // 1、主要事业成就
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "1、主要事业成就"
            tModel.content = model.career_achievement.defaultStringIfEmpty(detaultValue: "")
            tModel.type = .planDocQuestion1
            tModel.isFirstData = true
            arrHKPlanData.append(tModel)
        }
        
        // 2、学业成就
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "2、学业成就"
            tModel.content = model.academic_achievement.defaultStringIfEmpty(detaultValue: "")
            tModel.type = .planDocQuestion2
            arrHKPlanData.append(tModel)
        }
        
        // 3、专业资格
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "3、专业资格"
            tModel.content = model.qualifications_and_awards.defaultStringIfEmpty(detaultValue: "")
            tModel.type = .planDocQuestion3
            
            arrHKPlanData.append(tModel)
        }
        
        // 4、专业技能或人才清单内相关专业的成就
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "4、专业技能或人才清单内相关专业的成就"
            tModel.content = model.professional_skills.defaultStringIfEmpty(detaultValue: "")
            tModel.type = .planDocQuestion4
            tModel.other = model.talent_list.defaultStringIfEmpty(detaultValue: "")
            
            arrHKPlanData.append(tModel)
        }
        
        // 5、对香港的潜在贡献
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "5、对香港的潜在贡献"
            tModel.content = model.visa_contribution.defaultStringIfEmpty(detaultValue: "")
            tModel.type = .planDocQuestion5
            
            arrHKPlanData.append(tModel)
        }
        
        // 6、未来在香港发展事业的计划
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "6、未来在香港发展事业的计划"
            tModel.content = model.plan_detail.defaultStringIfEmpty(detaultValue: "")
            tModel.type = .planDocQuestion6
            
            arrHKPlanData.append(tModel)
        }
        
        // 7、认为对评核你的申请非常重要的其他资料
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "7、认为对评核你的申请非常重要的其他资料"
            tModel.content = model.other.defaultStringIfEmpty(detaultValue: "")
            tModel.type = .planOther
            tModel.isLastData = true
            
            arrHKPlanData.append(tModel)
        }
    }
}
