//
//  YHOtherTextViewItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHOtherTextViewItemType: Int {
    case unknowAwards = 0
    case professionAwards = 5 // 专业奖项
    case academicAwards = 6 // 学业奖项
    case otherAwards = 7 // 其他
}

class YHOtherTextViewItemView: UIView, UITextViewDelegate {
    
    static let viewH: CGFloat = 172.0
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    typealias Block = (String) -> Void
    var block: Block?
    
    var itemType: YHOtherTextViewItemType = .unknowAwards {
        didSet {
            switch itemType {
            case .unknowAwards:
                kTipsString = "请输入"
                case .professionAwards:
                kTipsString = "请填写您在所属的专业界别内曾获取由国家或国际认可/著名的团体颁授的专业资格、曾取得的奖项等"
                case .academicAwards:
                kTipsString = "请填写您的学业成绩、曾取得的奖项等"
                case .otherAwards:
                kTipsString = "请填写其他能对申请带来帮助的重要资料（如：拥有有利于申请的社会任职、相关国际人脉/业务或随行人员所具备的优势点等）"
            }
            tipsLabel.text = kTipsString
        }
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.lineBreakMode = .byCharWrapping
        label.text = "5、专业奖项"
        return label
    }()
    
    private lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .placeHolderColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.lineBreakMode = .byCharWrapping
        label.text = "5、专业奖项"
        return label
    }()
    
    private lazy var bottomLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    private lazy var additionHoldView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.contentBkgColor
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        return view
    }()
    
    private var myTextView: UITextView!
    private var kTipsString: String = "如选择“是”，请详细说明"
}

private extension YHOtherTextViewItemView {
    func setupUI() {
        backgroundColor = .clear
        //        title = "1、是否曾在香港或其他地方因任何罪行或违法行为被定罪?"
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(20)
        }
        
        addSubview(additionHoldView)
        additionHoldView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(104)
        }
        
        let textView: UITextView = UITextView()
        textView.backgroundColor = .clear
        textView.font = UIFont.PFSC_R(ofSize: 14)
        additionHoldView.addSubview(textView)
        textView.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        myTextView = textView
        myTextView.delegate = self
        myTextView.contentInset = UIEdgeInsets(top: 12, left: 12, bottom: 12, right: 12)
        
        additionHoldView.addSubview(tipsLabel)
        tipsLabel.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.left.equalTo(16)
            make.right.equalTo(-12)
        }
        
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.bottom.equalToSuperview()
        }
    }
}

extension YHOtherTextViewItemView: UITextFieldDelegate {
    internal func textViewDidChange(_ textView: UITextView) {
        if textView.text == "" {
            tipsLabel.isHidden = false
        } else {
            tipsLabel.isHidden = true
        }
        self.block?(textView.text)
    }
    
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        if !text.isEmpty {
            if textView.text.count > 1999 {
                return false
            }
        }
        return true
    }
}

extension YHOtherTextViewItemView {
    func updateUI(title: String, value: String, type: YHOtherTextViewItemType = .unknowAwards) {
        titleLabel.text = title
        myTextView.text = value
        itemType = type
        
        if value.count > 0 {
            tipsLabel.isHidden = true
        } else {
            tipsLabel.isHidden = false
        }
    }
}
