//
//  YHSelectMediaItem.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSelectMediaItem {
    var name: String
    var type: YHMediaType
    var image: UIImage?
    var videoURL: URL?
    var duration: TimeInterval?
    
    // 新增：上传状态管理
    var uploadState: UploadState = .pending
    var resourceURL: YHResourceURLs?  // 上传成功后的资源信息
    var uploadError: YHErrorModel?
    
    enum UploadState {
        case pending      // 待上传
        case uploading    // 上传中
        case success      // 上传成功
        case failed       // 上传失败
    }
    
    init(name: String = "", type: YHMediaType = .image, image: UIImage? = nil, videoURL: URL? = nil, duration: TimeInterval? = nil) {
        self.name = name
        self.type = type
        self.image = image
        self.videoURL = videoURL
        self.duration = duration
    }
}

enum YHMediaType {
    case image
    case video
}
