//
//  YHInformationAuthorizationStepTwoViewController.swift
//  galaxy
//
//  Created by EDY on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInformationAuthorizationStepTwoViewController: YHBaseViewController {
    var stepOneView: UIView!
    var stepTwoView: UIView!
    var nextButton: UIButton!
    var tableView: UITableView!
    var items: [YHSettingItem] = [YHSettingItem(type: .normal, title: "允许您的信息在名片中使用", subTitle: "开启后，您的信息将自动同步至您的个人名片，并对您的好友公开可见", isSelect: true, isShowAlert: false)]
    var viewModel: YHInformationAuthorizeViewModel = YHInformationAuthorizeViewModel()
    var stepFlag: Bool = true
    var name: String = ""
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        getData()
    }
    
    func getData() {
        if stepFlag {
            items = viewModel.getBaseSetDataSource()
            tableView.reloadData()
        } else {
            viewModel.requestUserAuthorization {[weak self] _, _ in
                guard let self = self else { return }
                items = viewModel.getBaseSetDataSource()
                tableView.reloadData()
            }
        }
    }
    
    func setView() {
        gk_navTitle = "信息授权"
        view.backgroundColor = .white
        
        stepOneView = {
            let view = UIView()
            view.backgroundColor = UIColor.brandMainColor
            return view
        }()
        view.addSubview(stepOneView)
        stepOneView.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 16)
            make.height.equalTo(3)
            make.right.equalTo(view.snp.centerX).offset(-3)
        }
        
        stepTwoView = {
            let view = UIView()
            view.backgroundColor = UIColor.brandMainColor
            return view
        }()
        view.addSubview(stepTwoView)
        stepTwoView.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 16)
            make.height.equalTo(3)
            make.left.equalTo(view.snp.centerX).offset(3)
        }
        
        nextButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("完成", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(nextStep), for: .touchUpInside)
            return button
        }()
        view.addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-8 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(48)
        }
        
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.backgroundColor = .white
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHAllowSettingTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(35 + k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 64)
            make.left.right.equalTo(view)
        }
        
        if !stepFlag {
            tableView.snp.remakeConstraints { make in
                make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
                make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 64)
                make.left.right.equalTo(view)
            }
            nextButton.setTitle("保存", for: .normal)
        }
    }
    
    @objc func nextStep() {
        viewModel.requestAuthorizationSubmit {[weak self] _, _ in
            guard let self = self else { return }
            if self.stepFlag {
                self.navigationController?.popToRootViewController(animated: true)
                let view = YHPeopleSuccessView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
                view.titleLabel.text = "Hi，\(self.name)\n您的人脉网络已激活"
                let window = UIApplication.shared.yhKeyWindow()
                window?.addSubview(view)
            } else {
                self.navigationController?.popViewController(animated: true)
            }
        }
    }
}

extension YHInformationAuthorizationStepTwoViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHAllowSettingTableViewCell.self)
        cell.item = items[indexPath.row]
        cell.block = { [weak self] model in
            guard let self = self else { return }
            self.viewModel.updateSetModel(model)
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 98.0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 0.01))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
}
